package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * notification open {
 *   uses open-message;
 * }
 * </pre>
 * <p>To create instances of this class use {@link OpenBuilder}.
 * @see OpenBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Open
    extends
    DataObject,
    Notification<Open>,
    OpenMessage,
    Augmentable<Open>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("open");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.@NonNull Open obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getBgpIdentifier());
        result = prime * result + Objects.hashCode(obj.getBgpParameters());
        result = prime * result + Objects.hashCode(obj.getHoldTimer());
        result = prime * result + Objects.hashCode(obj.getMyAsNumber());
        result = prime * result + Objects.hashCode(obj.getVersion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.@NonNull Open thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open.class, obj);
        return other != null
            && Objects.equals(thisObj.getHoldTimer(), other.getHoldTimer())
            && Objects.equals(thisObj.getMyAsNumber(), other.getMyAsNumber())
            && Objects.equals(thisObj.getVersion(), other.getVersion())
            && Objects.equals(thisObj.getBgpIdentifier(), other.getBgpIdentifier())
            && Objects.equals(thisObj.getBgpParameters(), other.getBgpParameters())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.@NonNull Open obj) {
        final var helper = MoreObjects.toStringHelper("Open");
        CodeHelpers.appendValue(helper, "bgpIdentifier", obj.getBgpIdentifier());
        CodeHelpers.appendValue(helper, "bgpParameters", obj.getBgpParameters());
        CodeHelpers.appendValue(helper, "holdTimer", obj.getHoldTimer());
        CodeHelpers.appendValue(helper, "myAsNumber", obj.getMyAsNumber());
        CodeHelpers.appendValue(helper, "version", obj.getVersion());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

