package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link Open} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Open createOpen(int fooXyzzy, int barBaz) {
 *         return new OpenBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Open, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Open
 *
 */
@Generated("mdsal-binding-generator")
public class OpenBuilder {

    private Ipv4AddressNoZone _bgpIdentifier;
    private List<BgpParameters> _bgpParameters;
    private Uint16 _holdTimer;
    private Uint16 _myAsNumber;
    private ProtocolVersion _version;


    Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public OpenBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link OpenMessage}.
     *
     * @param arg OpenMessage from which the builder should be initialized
     */
    public OpenBuilder(OpenMessage arg) {
        this._version = arg.getVersion();
        this._myAsNumber = arg.getMyAsNumber();
        this._holdTimer = arg.getHoldTimer();
        this._bgpIdentifier = arg.getBgpIdentifier();
        this._bgpParameters = arg.getBgpParameters();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Open}.
     *
     * @param base Open from which the builder should be initialized
     */
    public OpenBuilder(final Open base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bgpIdentifier = base.getBgpIdentifier();
        this._bgpParameters = base.getBgpParameters();
        this._holdTimer = base.getHoldTimer();
        this._myAsNumber = base.getMyAsNumber();
        this._version = base.getVersion();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link OpenMessage}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenMessage castArg) {
            this._version = castArg.getVersion();
            this._myAsNumber = castArg.getMyAsNumber();
            this._holdTimer = castArg.getHoldTimer();
            this._bgpIdentifier = castArg.getBgpIdentifier();
            this._bgpParameters = castArg.getBgpParameters();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OpenMessage]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Open#getBgpIdentifier()}.
     *
     * @return current value
     */
    public Ipv4AddressNoZone getBgpIdentifier() {
        return _bgpIdentifier;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Open#getBgpParameters()}.
     *
     * @return current value
     */
    public List<BgpParameters> getBgpParameters() {
        return _bgpParameters;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Open#getHoldTimer()}.
     *
     * @return current value
     */
    public Uint16 getHoldTimer() {
        return _holdTimer;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Open#getMyAsNumber()}.
     *
     * @return current value
     */
    public Uint16 getMyAsNumber() {
        return _myAsNumber;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Open#getVersion()}.
     *
     * @return current value
     */
    public ProtocolVersion getVersion() {
        return _version;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Open>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Open#getBgpIdentifier()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OpenBuilder setBgpIdentifier(final Ipv4AddressNoZone value) {
        this._bgpIdentifier = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Open#getBgpParameters()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public OpenBuilder setBgpParameters(final List<BgpParameters> values) {
        this._bgpParameters = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Open#getHoldTimer()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OpenBuilder setHoldTimer(final Uint16 value) {
        this._holdTimer = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Open#getMyAsNumber()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OpenBuilder setMyAsNumber(final Uint16 value) {
        this._myAsNumber = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Open#getVersion()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OpenBuilder setVersion(final ProtocolVersion value) {
        this._version = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public OpenBuilder addAugmentation(Augmentation<Open> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public OpenBuilder removeAugmentation(Class<? extends Augmentation<Open>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Open} instance.
     *
     * @return A new {@link Open} instance.
     */
    public @NonNull Open build() {
        return new OpenImpl(this);
    }

    private static final class OpenImpl
        extends AbstractAugmentable<Open>
        implements Open {
    
        private final Ipv4AddressNoZone _bgpIdentifier;
        private final List<BgpParameters> _bgpParameters;
        private final Uint16 _holdTimer;
        private final Uint16 _myAsNumber;
        private final ProtocolVersion _version;
    
        OpenImpl(final OpenBuilder base) {
            super(base.augmentation);
            this._bgpIdentifier = base.getBgpIdentifier();
            this._bgpParameters = CodeHelpers.emptyToNull(base.getBgpParameters());
            this._holdTimer = base.getHoldTimer();
            this._myAsNumber = base.getMyAsNumber();
            this._version = base.getVersion();
        }
    
        @Override
        public Ipv4AddressNoZone getBgpIdentifier() {
            return _bgpIdentifier;
        }
        
        @Override
        public List<BgpParameters> getBgpParameters() {
            return _bgpParameters;
        }
        
        @Override
        public Uint16 getHoldTimer() {
            return _holdTimer;
        }
        
        @Override
        public Uint16 getMyAsNumber() {
            return _myAsNumber;
        }
        
        @Override
        public ProtocolVersion getVersion() {
            return _version;
        }
    
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Open.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Open.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Open.bindingToString(this);
        }
    }
}
