package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Open Message
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping open-message {
 *   leaf version {
 *     type protocol-version;
 *     default 4;
 *   }
 *   leaf my-as-number {
 *     type uint16;
 *     default 23456;
 *   }
 *   leaf hold-timer {
 *     type uint16;
 *   }
 *   leaf bgp-identifier {
 *     type inet:ipv4-address-no-zone;
 *   }
 *   list bgp-parameters {
 *     list optional-capabilities {
 *       container c-parameters {
 *         container as4-bytes-capability {
 *           leaf as-number {
 *             type inet:as-number;
 *           }
 *         }
 *         container bgp-extended-message-capability {
 *           presence "Indicates peer is able to send/receive 64K messages";
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenMessage
    extends
    Grouping
{




    /**
     * Return version, or {@code null} if it is not present.
     *
     * @return {@code ProtocolVersion} version, or {@code null} if it is not present.
     *
     */
    ProtocolVersion getVersion();
    
    /**
     * Return version, guaranteed to be non-null.
     *
     * @return {@code ProtocolVersion} version, guaranteed to be non-null.
     * @throws NoSuchElementException if version is not present
     *
     */
    default @NonNull ProtocolVersion requireVersion() {
        return CodeHelpers.require(getVersion(), "version");
    }
    
    /**
     * Return myAsNumber, or {@code null} if it is not present.
     *
     * @return {@code Uint16} myAsNumber, or {@code null} if it is not present.
     *
     */
    Uint16 getMyAsNumber();
    
    /**
     * Return myAsNumber, guaranteed to be non-null.
     *
     * @return {@code Uint16} myAsNumber, guaranteed to be non-null.
     * @throws NoSuchElementException if myAsNumber is not present
     *
     */
    default @NonNull Uint16 requireMyAsNumber() {
        return CodeHelpers.require(getMyAsNumber(), "myasnumber");
    }
    
    /**
     * Return holdTimer, or {@code null} if it is not present.
     *
     * @return {@code Uint16} holdTimer, or {@code null} if it is not present.
     *
     */
    Uint16 getHoldTimer();
    
    /**
     * Return holdTimer, guaranteed to be non-null.
     *
     * @return {@code Uint16} holdTimer, guaranteed to be non-null.
     * @throws NoSuchElementException if holdTimer is not present
     *
     */
    default @NonNull Uint16 requireHoldTimer() {
        return CodeHelpers.require(getHoldTimer(), "holdtimer");
    }
    
    /**
     * Return bgpIdentifier, or {@code null} if it is not present.
     *
     * @return {@code Ipv4AddressNoZone} bgpIdentifier, or {@code null} if it is not present.
     *
     */
    Ipv4AddressNoZone getBgpIdentifier();
    
    /**
     * Return bgpIdentifier, guaranteed to be non-null.
     *
     * @return {@code Ipv4AddressNoZone} bgpIdentifier, guaranteed to be non-null.
     * @throws NoSuchElementException if bgpIdentifier is not present
     *
     */
    default @NonNull Ipv4AddressNoZone requireBgpIdentifier() {
        return CodeHelpers.require(getBgpIdentifier(), "bgpidentifier");
    }
    
    /**
     * Return bgpParameters, or {@code null} if it is not present.
     *
     * @return {@code List<BgpParameters>} bgpParameters, or {@code null} if it is not present.
     *
     */
    @Nullable List<BgpParameters> getBgpParameters();
    
    /**
     * Return bgpParameters, or an empty list if it is not present.
     *
     * @return {@code List<BgpParameters>} bgpParameters, or an empty list if it is not present.
     *
     */
    default @NonNull List<BgpParameters> nonnullBgpParameters() {
        return CodeHelpers.nonnull(getBgpParameters());
    }

}

