package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping originator-id {
 *   leaf originator {
 *     type inet:ipv4-address-no-zone;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OriginatorId
    extends
    Grouping
{




    /**
     * Return originator, or {@code null} if it is not present.
     *
     * @return {@code Ipv4AddressNoZone} originator, or {@code null} if it is not present.
     *
     */
    Ipv4AddressNoZone getOriginator();
    
    /**
     * Return originator, guaranteed to be non-null.
     *
     * @return {@code Ipv4AddressNoZone} originator, guaranteed to be non-null.
     * @throws NoSuchElementException if originator is not present
     *
     */
    default @NonNull Ipv4AddressNoZone requireOriginator() {
        return CodeHelpers.require(getOriginator(), "originator");
    }

}

