package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.binding.ScalarTypeObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * typedef protocol-version {
 *   type uint8 {
 *     range 1..7;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class ProtocolVersion
 implements ScalarTypeObject<Uint8>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = -7283574556842814269L;
    private final Uint8 _value;

    private static void check_valueRange(final short value) {
        if (value >= (short)1 && value <= (short)7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..7]]", value);
    }

    @ConstructorParameters("value")
    public ProtocolVersion(Uint8 _value) {
        if (_value != null) {
            check_valueRange(_value.shortValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ProtocolVersion(ProtocolVersion source) {
        this._value = source._value;
    }

    public static ProtocolVersion getDefaultInstance(final String defaultValue) {
        return new ProtocolVersion(Uint8.valueOf(defaultValue));
    }

    @Override
    public Uint8 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof ProtocolVersion other
            && Objects.equals(_value, other._value);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(ProtocolVersion.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

