package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutes;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link Update} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Update createUpdate(int fooXyzzy, int barBaz) {
 *         return new UpdateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Update, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Update
 *
 */
@Generated("mdsal-binding-generator")
public class UpdateBuilder {

    private Attributes _attributes;
    private List<Nlri> _nlri;
    private List<WithdrawnRoutes> _withdrawnRoutes;


    Map<Class<? extends Augmentation<Update>>, Augmentation<Update>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UpdateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link UpdateMessage}.
     *
     * @param arg UpdateMessage from which the builder should be initialized
     */
    public UpdateBuilder(UpdateMessage arg) {
        this._withdrawnRoutes = arg.getWithdrawnRoutes();
        this._nlri = arg.getNlri();
        this._attributes = arg.getAttributes();
    }
    
    /**
     * Construct a new builder initialized from specified {@link PathAttributes}.
     *
     * @param arg PathAttributes from which the builder should be initialized
     */
    public UpdateBuilder(PathAttributes arg) {
        this._attributes = arg.getAttributes();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Update}.
     *
     * @param base Update from which the builder should be initialized
     */
    public UpdateBuilder(final Update base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._attributes = base.getAttributes();
        this._nlri = base.getNlri();
        this._withdrawnRoutes = base.getWithdrawnRoutes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link UpdateMessage}</li>
     *   <li>{@link PathAttributes}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof UpdateMessage castArg) {
            this._withdrawnRoutes = castArg.getWithdrawnRoutes();
            this._nlri = castArg.getNlri();
            isValidArg = true;
        }
        if (arg instanceof PathAttributes castArg) {
            this._attributes = castArg.getAttributes();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[UpdateMessage, PathAttributes]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Update#getAttributes()}.
     *
     * @return current value
     */
    public Attributes getAttributes() {
        return _attributes;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Update#getNlri()}.
     *
     * @return current value
     */
    public List<Nlri> getNlri() {
        return _nlri;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Update#getWithdrawnRoutes()}.
     *
     * @return current value
     */
    public List<WithdrawnRoutes> getWithdrawnRoutes() {
        return _withdrawnRoutes;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Update>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Update#getAttributes()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UpdateBuilder setAttributes(final Attributes value) {
        this._attributes = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Update#getNlri()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public UpdateBuilder setNlri(final List<Nlri> values) {
        this._nlri = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Update#getWithdrawnRoutes()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public UpdateBuilder setWithdrawnRoutes(final List<WithdrawnRoutes> values) {
        this._withdrawnRoutes = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UpdateBuilder addAugmentation(Augmentation<Update> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UpdateBuilder removeAugmentation(Class<? extends Augmentation<Update>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Update} instance.
     *
     * @return A new {@link Update} instance.
     */
    public @NonNull Update build() {
        return new UpdateImpl(this);
    }

    private static final class UpdateImpl
        extends AbstractAugmentable<Update>
        implements Update {
    
        private final Attributes _attributes;
        private final List<Nlri> _nlri;
        private final List<WithdrawnRoutes> _withdrawnRoutes;
    
        UpdateImpl(final UpdateBuilder base) {
            super(base.augmentation);
            this._attributes = base.getAttributes();
            this._nlri = CodeHelpers.emptyToNull(base.getNlri());
            this._withdrawnRoutes = CodeHelpers.emptyToNull(base.getWithdrawnRoutes());
        }
    
        @Override
        public Attributes getAttributes() {
            return _attributes;
        }
        
        @Override
        public List<Nlri> getNlri() {
            return _nlri;
        }
        
        @Override
        public List<WithdrawnRoutes> getWithdrawnRoutes() {
            return _withdrawnRoutes;
        }
    
        @Override
        public Attributes nonnullAttributes() {
            return Objects.requireNonNullElse(getAttributes(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Update.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Update.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Update.bindingToString(this);
        }
    }
}
