package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120;
import java.util.List;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutes;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Update Message
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * grouping update-message {
 *   uses path-attributes;
 *   list withdrawn-routes {
 *     uses ipv4-prefix-and-path-id;
 *   }
 *   list nlri {
 *     uses ipv4-prefix-and-path-id;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface UpdateMessage
    extends
    Grouping,
    PathAttributes
{




    /**
     * Return withdrawnRoutes, or {@code null} if it is not present.
     *
     * @return {@code List<WithdrawnRoutes>} withdrawnRoutes, or {@code null} if it is not present.
     *
     */
    @Nullable List<WithdrawnRoutes> getWithdrawnRoutes();
    
    /**
     * Return withdrawnRoutes, or an empty list if it is not present.
     *
     * @return {@code List<WithdrawnRoutes>} withdrawnRoutes, or an empty list if it is not present.
     *
     */
    default @NonNull List<WithdrawnRoutes> nonnullWithdrawnRoutes() {
        return CodeHelpers.nonnull(getWithdrawnRoutes());
    }
    
    /**
     * Return nlri, or {@code null} if it is not present.
     *
     * @return {@code List<Nlri>} nlri, or {@code null} if it is not present.
     *
     */
    @Nullable List<Nlri> getNlri();
    
    /**
     * Return nlri, or an empty list if it is not present.
     *
     * @return {@code List<Nlri>} nlri, or an empty list if it is not present.
     *
     */
    default @NonNull List<Nlri> nonnullNlri() {
        return CodeHelpers.nonnull(getNlri());
    }

}

