package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.BgpExtendedMessageCapability;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * container c-parameters {
 *   container as4-bytes-capability {
 *     leaf as-number {
 *       type inet:as-number;
 *     }
 *   }
 *   container bgp-extended-message-capability {
 *     presence "Indicates peer is able to send/receive 64K messages";
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link CParametersBuilder}.
 * @see CParametersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface CParameters
    extends
    ChildOf<OptionalCapabilities>,
    Augmentable<CParameters>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("c-parameters");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.@NonNull CParameters obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAs4BytesCapability());
        result = prime * result + Objects.hashCode(obj.getBgpExtendedMessageCapability());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.@NonNull CParameters thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters.class, obj);
        return other != null
            && Objects.equals(thisObj.getAs4BytesCapability(), other.getAs4BytesCapability())
            && Objects.equals(thisObj.getBgpExtendedMessageCapability(), other.getBgpExtendedMessageCapability())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.@NonNull CParameters obj) {
        final var helper = MoreObjects.toStringHelper("CParameters");
        CodeHelpers.appendValue(helper, "as4BytesCapability", obj.getAs4BytesCapability());
        CodeHelpers.appendValue(helper, "bgpExtendedMessageCapability", obj.getBgpExtendedMessageCapability());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return as4BytesCapability, or {@code null} if it is not present.
     *
     * @return {@code As4BytesCapability} as4BytesCapability, or {@code null} if it is not present.
     *
     */
    As4BytesCapability getAs4BytesCapability();
    
    /**
     * Return as4BytesCapability, or an empty instance if it is not present.
     *
     * @return {@code As4BytesCapability} as4BytesCapability, or an empty instance if it is not present.
     *
     */
    @NonNull As4BytesCapability nonnullAs4BytesCapability();
    
    /**
     * Return bgpExtendedMessageCapability, or {@code null} if it is not present.
     *
     * @return {@code BgpExtendedMessageCapability} bgpExtendedMessageCapability, or {@code null} if it is not present.
     *
     */
    BgpExtendedMessageCapability getBgpExtendedMessageCapability();

}

