package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.BgpExtendedMessageCapability;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;

/**
 * Class that builds {@link CParameters} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     CParameters createCParameters(int fooXyzzy, int barBaz) {
 *         return new CParametersBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of CParameters, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see CParameters
 *
 */
@Generated("mdsal-binding-generator")
public class CParametersBuilder {

    private As4BytesCapability _as4BytesCapability;
    private BgpExtendedMessageCapability _bgpExtendedMessageCapability;


    Map<Class<? extends Augmentation<CParameters>>, Augmentation<CParameters>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public CParametersBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link CParameters}.
     *
     * @param base CParameters from which the builder should be initialized
     */
    public CParametersBuilder(final CParameters base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._as4BytesCapability = base.getAs4BytesCapability();
        this._bgpExtendedMessageCapability = base.getBgpExtendedMessageCapability();
    }


    private static final class LazyEmpty {
        static final @NonNull CParameters INSTANCE = new CParametersBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of CParameters.
     *
     * @return An empty {@link CParameters}
     */
    public static @NonNull CParameters empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link CParameters#getAs4BytesCapability()}.
     *
     * @return current value
     */
    public As4BytesCapability getAs4BytesCapability() {
        return _as4BytesCapability;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CParameters#getBgpExtendedMessageCapability()}.
     *
     * @return current value
     */
    public BgpExtendedMessageCapability getBgpExtendedMessageCapability() {
        return _bgpExtendedMessageCapability;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<CParameters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link CParameters#getAs4BytesCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CParametersBuilder setAs4BytesCapability(final As4BytesCapability value) {
        this._as4BytesCapability = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CParameters#getBgpExtendedMessageCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CParametersBuilder setBgpExtendedMessageCapability(final BgpExtendedMessageCapability value) {
        this._bgpExtendedMessageCapability = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CParametersBuilder addAugmentation(Augmentation<CParameters> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CParametersBuilder removeAugmentation(Class<? extends Augmentation<CParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link CParameters} instance.
     *
     * @return A new {@link CParameters} instance.
     */
    public @NonNull CParameters build() {
        return new CParametersImpl(this);
    }

    private static final class CParametersImpl
        extends AbstractAugmentable<CParameters>
        implements CParameters {
    
        private final As4BytesCapability _as4BytesCapability;
        private final BgpExtendedMessageCapability _bgpExtendedMessageCapability;
    
        CParametersImpl(final CParametersBuilder base) {
            super(base.augmentation);
            this._as4BytesCapability = base.getAs4BytesCapability();
            this._bgpExtendedMessageCapability = base.getBgpExtendedMessageCapability();
        }
    
        @Override
        public As4BytesCapability getAs4BytesCapability() {
            return _as4BytesCapability;
        }
        
        @Override
        public BgpExtendedMessageCapability getBgpExtendedMessageCapability() {
            return _bgpExtendedMessageCapability;
        }
    
        @Override
        public As4BytesCapability nonnullAs4BytesCapability() {
            return Objects.requireNonNullElse(getAs4BytesCapability(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder.empty());
        }
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = CParameters.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return CParameters.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return CParameters.bindingToString(this);
        }
    }
}
