package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.BgpPrefixSid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.NextHop;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-message</b>
 * <pre>
 * container attributes {
 *   container origin {
 *     leaf value {
 *       type bgp-t:bgp-origin;
 *     }
 *   }
 *   container as-path {
 *     list segments {
 *       uses bgp-t:as-path-segment;
 *     }
 *   }
 *   uses bgp-t:next-hop;
 *   container multi-exit-disc {
 *     leaf med {
 *       type uint32;
 *     }
 *   }
 *   container local-pref {
 *     leaf pref {
 *       type uint32;
 *     }
 *   }
 *   container atomic-aggregate {
 *     presence "Atomic Aggregate attribute is present.";
 *   }
 *   container aggregator {
 *     uses bgp-t:bgp-aggregator;
 *   }
 *   list communities {
 *     uses bgp-t:community;
 *   }
 *   list extended-communities {
 *     uses bgp-t:extended-community;
 *   }
 *   container originator-id {
 *     uses originator-id;
 *   }
 *   container cluster-id {
 *     uses cluster-id;
 *   }
 *   container aigp {
 *     container aigp-tlv {
 *       leaf metric {
 *         type netc:accumulated-igp-metric;
 *       }
 *     }
 *   }
 *   list unrecognized-attributes {
 *     key type;
 *     leaf partial {
 *       type boolean;
 *     }
 *     leaf transitive {
 *       type boolean;
 *     }
 *     leaf type {
 *       type uint8;
 *     }
 *     leaf value {
 *       type binary {
 *         length 0..65535;
 *       }
 *     }
 *   }
 *   container bgp-prefix-sid {
 *     list bgp-prefix-sid-tlvs {
 *       choice bgp-prefix-sid-tlv {
 *       }
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link AttributesBuilder}.
 * @see AttributesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Attributes
    extends
    ChildOf<PathAttributes>,
    Augmentable<Attributes>,
    NextHop
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("attributes");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.@NonNull Attributes obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAggregator());
        result = prime * result + Objects.hashCode(obj.getAigp());
        result = prime * result + Objects.hashCode(obj.getAsPath());
        result = prime * result + Objects.hashCode(obj.getAtomicAggregate());
        result = prime * result + Objects.hashCode(obj.getBgpPrefixSid());
        result = prime * result + Objects.hashCode(obj.getCNextHop());
        result = prime * result + Objects.hashCode(obj.getClusterId());
        result = prime * result + Objects.hashCode(obj.getCommunities());
        result = prime * result + Objects.hashCode(obj.getExtendedCommunities());
        result = prime * result + Objects.hashCode(obj.getLocalPref());
        result = prime * result + Objects.hashCode(obj.getMultiExitDisc());
        result = prime * result + Objects.hashCode(obj.getOrigin());
        result = prime * result + Objects.hashCode(obj.getOriginatorId());
        result = prime * result + Objects.hashCode(obj.getUnrecognizedAttributes());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.@NonNull Attributes thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes.class, obj);
        return other != null
            && Objects.equals(thisObj.getAggregator(), other.getAggregator())
            && Objects.equals(thisObj.getAigp(), other.getAigp())
            && Objects.equals(thisObj.getAsPath(), other.getAsPath())
            && Objects.equals(thisObj.getAtomicAggregate(), other.getAtomicAggregate())
            && Objects.equals(thisObj.getBgpPrefixSid(), other.getBgpPrefixSid())
            && Objects.equals(thisObj.getCNextHop(), other.getCNextHop())
            && Objects.equals(thisObj.getClusterId(), other.getClusterId())
            && Objects.equals(thisObj.getCommunities(), other.getCommunities())
            && Objects.equals(thisObj.getExtendedCommunities(), other.getExtendedCommunities())
            && Objects.equals(thisObj.getLocalPref(), other.getLocalPref())
            && Objects.equals(thisObj.getMultiExitDisc(), other.getMultiExitDisc())
            && Objects.equals(thisObj.getOrigin(), other.getOrigin())
            && Objects.equals(thisObj.getOriginatorId(), other.getOriginatorId())
            && Objects.equals(thisObj.getUnrecognizedAttributes(), other.getUnrecognizedAttributes())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.@NonNull Attributes obj) {
        final var helper = MoreObjects.toStringHelper("Attributes");
        CodeHelpers.appendValue(helper, "aggregator", obj.getAggregator());
        CodeHelpers.appendValue(helper, "aigp", obj.getAigp());
        CodeHelpers.appendValue(helper, "asPath", obj.getAsPath());
        CodeHelpers.appendValue(helper, "atomicAggregate", obj.getAtomicAggregate());
        CodeHelpers.appendValue(helper, "bgpPrefixSid", obj.getBgpPrefixSid());
        CodeHelpers.appendValue(helper, "cNextHop", obj.getCNextHop());
        CodeHelpers.appendValue(helper, "clusterId", obj.getClusterId());
        CodeHelpers.appendValue(helper, "communities", obj.getCommunities());
        CodeHelpers.appendValue(helper, "extendedCommunities", obj.getExtendedCommunities());
        CodeHelpers.appendValue(helper, "localPref", obj.getLocalPref());
        CodeHelpers.appendValue(helper, "multiExitDisc", obj.getMultiExitDisc());
        CodeHelpers.appendValue(helper, "origin", obj.getOrigin());
        CodeHelpers.appendValue(helper, "originatorId", obj.getOriginatorId());
        CodeHelpers.appendValue(helper, "unrecognizedAttributes", obj.getUnrecognizedAttributes());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return origin, or {@code null} if it is not present.
     *
     * @return {@code Origin} origin, or {@code null} if it is not present.
     *
     */
    Origin getOrigin();
    
    /**
     * Return origin, or an empty instance if it is not present.
     *
     * @return {@code Origin} origin, or an empty instance if it is not present.
     *
     */
    @NonNull Origin nonnullOrigin();
    
    /**
     * Return asPath, or {@code null} if it is not present.
     *
     * @return {@code AsPath} asPath, or {@code null} if it is not present.
     *
     */
    AsPath getAsPath();
    
    /**
     * Return asPath, or an empty instance if it is not present.
     *
     * @return {@code AsPath} asPath, or an empty instance if it is not present.
     *
     */
    @NonNull AsPath nonnullAsPath();
    
    /**
     * Return multiExitDisc, or {@code null} if it is not present.
     *
     * @return {@code MultiExitDisc} multiExitDisc, or {@code null} if it is not present.
     *
     */
    MultiExitDisc getMultiExitDisc();
    
    /**
     * Return multiExitDisc, or an empty instance if it is not present.
     *
     * @return {@code MultiExitDisc} multiExitDisc, or an empty instance if it is not present.
     *
     */
    @NonNull MultiExitDisc nonnullMultiExitDisc();
    
    /**
     * Return localPref, or {@code null} if it is not present.
     *
     * @return {@code LocalPref} localPref, or {@code null} if it is not present.
     *
     */
    LocalPref getLocalPref();
    
    /**
     * Return localPref, or an empty instance if it is not present.
     *
     * @return {@code LocalPref} localPref, or an empty instance if it is not present.
     *
     */
    @NonNull LocalPref nonnullLocalPref();
    
    /**
     * Return atomicAggregate, or {@code null} if it is not present.
     *
     * @return {@code AtomicAggregate} atomicAggregate, or {@code null} if it is not present.
     *
     */
    AtomicAggregate getAtomicAggregate();
    
    /**
     * Return aggregator, or {@code null} if it is not present.
     *
     * @return {@code Aggregator} aggregator, or {@code null} if it is not present.
     *
     */
    Aggregator getAggregator();
    
    /**
     * Return aggregator, or an empty instance if it is not present.
     *
     * @return {@code Aggregator} aggregator, or an empty instance if it is not present.
     *
     */
    @NonNull Aggregator nonnullAggregator();
    
    /**
     * Return communities, or {@code null} if it is not present.
     *
     * @return {@code List<Communities>} communities, or {@code null} if it is not present.
     *
     */
    @Nullable List<Communities> getCommunities();
    
    /**
     * Return communities, or an empty list if it is not present.
     *
     * @return {@code List<Communities>} communities, or an empty list if it is not present.
     *
     */
    default @NonNull List<Communities> nonnullCommunities() {
        return CodeHelpers.nonnull(getCommunities());
    }
    
    /**
     * Return extendedCommunities, or {@code null} if it is not present.
     *
     * @return {@code List<ExtendedCommunities>} extendedCommunities, or {@code null} if it is not present.
     *
     */
    @Nullable List<ExtendedCommunities> getExtendedCommunities();
    
    /**
     * Return extendedCommunities, or an empty list if it is not present.
     *
     * @return {@code List<ExtendedCommunities>} extendedCommunities, or an empty list if it is not present.
     *
     */
    default @NonNull List<ExtendedCommunities> nonnullExtendedCommunities() {
        return CodeHelpers.nonnull(getExtendedCommunities());
    }
    
    /**
     * Return originatorId, or {@code null} if it is not present.
     *
     * @return {@code OriginatorId} originatorId, or {@code null} if it is not present.
     *
     */
    OriginatorId getOriginatorId();
    
    /**
     * Return originatorId, or an empty instance if it is not present.
     *
     * @return {@code OriginatorId} originatorId, or an empty instance if it is not present.
     *
     */
    @NonNull OriginatorId nonnullOriginatorId();
    
    /**
     * Return clusterId, or {@code null} if it is not present.
     *
     * @return {@code ClusterId} clusterId, or {@code null} if it is not present.
     *
     */
    ClusterId getClusterId();
    
    /**
     * Return clusterId, or an empty instance if it is not present.
     *
     * @return {@code ClusterId} clusterId, or an empty instance if it is not present.
     *
     */
    @NonNull ClusterId nonnullClusterId();
    
    /**
     * Return aigp, or {@code null} if it is not present.
     *
     * @return {@code Aigp} aigp, or {@code null} if it is not present.
     *
     */
    Aigp getAigp();
    
    /**
     * Return aigp, or an empty instance if it is not present.
     *
     * @return {@code Aigp} aigp, or an empty instance if it is not present.
     *
     */
    @NonNull Aigp nonnullAigp();
    
    /**
     * Return unrecognizedAttributes, or {@code null} if it is not present.
     *
     * @return {@code Map<UnrecognizedAttributesKey, UnrecognizedAttributes>} unrecognizedAttributes, or {@code null} if it is not present.
     *
     */
    @Nullable Map<UnrecognizedAttributesKey, UnrecognizedAttributes> getUnrecognizedAttributes();
    
    /**
     * Return unrecognizedAttributes, or an empty list if it is not present.
     *
     * @return {@code Map<UnrecognizedAttributesKey, UnrecognizedAttributes>} unrecognizedAttributes, or an empty list if it is not present.
     *
     */
    default @NonNull Map<UnrecognizedAttributesKey, UnrecognizedAttributes> nonnullUnrecognizedAttributes() {
        return CodeHelpers.nonnull(getUnrecognizedAttributes());
    }
    
    /**
     * Return bgpPrefixSid, or {@code null} if it is not present.
     *
     * @return {@code BgpPrefixSid} bgpPrefixSid, or {@code null} if it is not present.
     *
     */
    BgpPrefixSid getBgpPrefixSid();
    
    /**
     * Return bgpPrefixSid, or an empty instance if it is not present.
     *
     * @return {@code BgpPrefixSid} bgpPrefixSid, or an empty instance if it is not present.
     *
     */
    @NonNull BgpPrefixSid nonnullBgpPrefixSid();

}

