package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.BgpPrefixSid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link Attributes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Attributes createAttributes(int fooXyzzy, int barBaz) {
 *         return new AttributesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Attributes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Attributes
 *
 */
@Generated("mdsal-binding-generator")
public class AttributesBuilder {

    private Aggregator _aggregator;
    private Aigp _aigp;
    private AsPath _asPath;
    private AtomicAggregate _atomicAggregate;
    private BgpPrefixSid _bgpPrefixSid;
    private CNextHop _cNextHop;
    private ClusterId _clusterId;
    private List<Communities> _communities;
    private List<ExtendedCommunities> _extendedCommunities;
    private LocalPref _localPref;
    private MultiExitDisc _multiExitDisc;
    private Origin _origin;
    private OriginatorId _originatorId;
    private Map<UnrecognizedAttributesKey, UnrecognizedAttributes> _unrecognizedAttributes;


    Map<Class<? extends Augmentation<Attributes>>, Augmentation<Attributes>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AttributesBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link NextHop}.
     *
     * @param arg NextHop from which the builder should be initialized
     */
    public AttributesBuilder(NextHop arg) {
        this._cNextHop = arg.getCNextHop();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Attributes}.
     *
     * @param base Attributes from which the builder should be initialized
     */
    public AttributesBuilder(final Attributes base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._aggregator = base.getAggregator();
        this._aigp = base.getAigp();
        this._asPath = base.getAsPath();
        this._atomicAggregate = base.getAtomicAggregate();
        this._bgpPrefixSid = base.getBgpPrefixSid();
        this._cNextHop = base.getCNextHop();
        this._clusterId = base.getClusterId();
        this._communities = base.getCommunities();
        this._extendedCommunities = base.getExtendedCommunities();
        this._localPref = base.getLocalPref();
        this._multiExitDisc = base.getMultiExitDisc();
        this._origin = base.getOrigin();
        this._originatorId = base.getOriginatorId();
        this._unrecognizedAttributes = base.getUnrecognizedAttributes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link NextHop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof NextHop castArg) {
            this._cNextHop = castArg.getCNextHop();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NextHop]");
    }

    private static final class LazyEmpty {
        static final @NonNull Attributes INSTANCE = new AttributesBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Attributes.
     *
     * @return An empty {@link Attributes}
     */
    public static @NonNull Attributes empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Attributes#getAggregator()}.
     *
     * @return current value
     */
    public Aggregator getAggregator() {
        return _aggregator;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getAigp()}.
     *
     * @return current value
     */
    public Aigp getAigp() {
        return _aigp;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getAsPath()}.
     *
     * @return current value
     */
    public AsPath getAsPath() {
        return _asPath;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getAtomicAggregate()}.
     *
     * @return current value
     */
    public AtomicAggregate getAtomicAggregate() {
        return _atomicAggregate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getBgpPrefixSid()}.
     *
     * @return current value
     */
    public BgpPrefixSid getBgpPrefixSid() {
        return _bgpPrefixSid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getCNextHop()}.
     *
     * @return current value
     */
    public CNextHop getCNextHop() {
        return _cNextHop;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getClusterId()}.
     *
     * @return current value
     */
    public ClusterId getClusterId() {
        return _clusterId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getCommunities()}.
     *
     * @return current value
     */
    public List<Communities> getCommunities() {
        return _communities;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getExtendedCommunities()}.
     *
     * @return current value
     */
    public List<ExtendedCommunities> getExtendedCommunities() {
        return _extendedCommunities;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getLocalPref()}.
     *
     * @return current value
     */
    public LocalPref getLocalPref() {
        return _localPref;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getMultiExitDisc()}.
     *
     * @return current value
     */
    public MultiExitDisc getMultiExitDisc() {
        return _multiExitDisc;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getOrigin()}.
     *
     * @return current value
     */
    public Origin getOrigin() {
        return _origin;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getOriginatorId()}.
     *
     * @return current value
     */
    public OriginatorId getOriginatorId() {
        return _originatorId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Attributes#getUnrecognizedAttributes()}.
     *
     * @return current value
     */
    public Map<UnrecognizedAttributesKey, UnrecognizedAttributes> getUnrecognizedAttributes() {
        return _unrecognizedAttributes;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Attributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Attributes#getAggregator()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setAggregator(final Aggregator value) {
        this._aggregator = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getAigp()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setAigp(final Aigp value) {
        this._aigp = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getAsPath()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setAsPath(final AsPath value) {
        this._asPath = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getAtomicAggregate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setAtomicAggregate(final AtomicAggregate value) {
        this._atomicAggregate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getBgpPrefixSid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setBgpPrefixSid(final BgpPrefixSid value) {
        this._bgpPrefixSid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getCNextHop()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setCNextHop(final CNextHop value) {
        this._cNextHop = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getClusterId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setClusterId(final ClusterId value) {
        this._clusterId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getCommunities()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public AttributesBuilder setCommunities(final List<Communities> values) {
        this._communities = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Attributes#getExtendedCommunities()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public AttributesBuilder setExtendedCommunities(final List<ExtendedCommunities> values) {
        this._extendedCommunities = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Attributes#getLocalPref()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setLocalPref(final LocalPref value) {
        this._localPref = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getMultiExitDisc()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setMultiExitDisc(final MultiExitDisc value) {
        this._multiExitDisc = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getOrigin()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setOrigin(final Origin value) {
        this._origin = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getOriginatorId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesBuilder setOriginatorId(final OriginatorId value) {
        this._originatorId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Attributes#getUnrecognizedAttributes()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public AttributesBuilder setUnrecognizedAttributes(final Map<UnrecognizedAttributesKey, UnrecognizedAttributes> values) {
        this._unrecognizedAttributes = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AttributesBuilder addAugmentation(Augmentation<Attributes> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AttributesBuilder removeAugmentation(Class<? extends Augmentation<Attributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Attributes} instance.
     *
     * @return A new {@link Attributes} instance.
     */
    public @NonNull Attributes build() {
        return new AttributesImpl(this);
    }

    private static final class AttributesImpl
        extends AbstractAugmentable<Attributes>
        implements Attributes {
    
        private final Aggregator _aggregator;
        private final Aigp _aigp;
        private final AsPath _asPath;
        private final AtomicAggregate _atomicAggregate;
        private final BgpPrefixSid _bgpPrefixSid;
        private final CNextHop _cNextHop;
        private final ClusterId _clusterId;
        private final List<Communities> _communities;
        private final List<ExtendedCommunities> _extendedCommunities;
        private final LocalPref _localPref;
        private final MultiExitDisc _multiExitDisc;
        private final Origin _origin;
        private final OriginatorId _originatorId;
        private final Map<UnrecognizedAttributesKey, UnrecognizedAttributes> _unrecognizedAttributes;
    
        AttributesImpl(final AttributesBuilder base) {
            super(base.augmentation);
            this._aggregator = base.getAggregator();
            this._aigp = base.getAigp();
            this._asPath = base.getAsPath();
            this._atomicAggregate = base.getAtomicAggregate();
            this._bgpPrefixSid = base.getBgpPrefixSid();
            this._cNextHop = base.getCNextHop();
            this._clusterId = base.getClusterId();
            this._communities = CodeHelpers.emptyToNull(base.getCommunities());
            this._extendedCommunities = CodeHelpers.emptyToNull(base.getExtendedCommunities());
            this._localPref = base.getLocalPref();
            this._multiExitDisc = base.getMultiExitDisc();
            this._origin = base.getOrigin();
            this._originatorId = base.getOriginatorId();
            this._unrecognizedAttributes = CodeHelpers.emptyToNull(base.getUnrecognizedAttributes());
        }
    
        @Override
        public Aggregator getAggregator() {
            return _aggregator;
        }
        
        @Override
        public Aigp getAigp() {
            return _aigp;
        }
        
        @Override
        public AsPath getAsPath() {
            return _asPath;
        }
        
        @Override
        public AtomicAggregate getAtomicAggregate() {
            return _atomicAggregate;
        }
        
        @Override
        public BgpPrefixSid getBgpPrefixSid() {
            return _bgpPrefixSid;
        }
        
        @Override
        public CNextHop getCNextHop() {
            return _cNextHop;
        }
        
        @Override
        public ClusterId getClusterId() {
            return _clusterId;
        }
        
        @Override
        public List<Communities> getCommunities() {
            return _communities;
        }
        
        @Override
        public List<ExtendedCommunities> getExtendedCommunities() {
            return _extendedCommunities;
        }
        
        @Override
        public LocalPref getLocalPref() {
            return _localPref;
        }
        
        @Override
        public MultiExitDisc getMultiExitDisc() {
            return _multiExitDisc;
        }
        
        @Override
        public Origin getOrigin() {
            return _origin;
        }
        
        @Override
        public OriginatorId getOriginatorId() {
            return _originatorId;
        }
        
        @Override
        public Map<UnrecognizedAttributesKey, UnrecognizedAttributes> getUnrecognizedAttributes() {
            return _unrecognizedAttributes;
        }
    
        @Override
        public Aggregator nonnullAggregator() {
            return Objects.requireNonNullElse(getAggregator(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AggregatorBuilder.empty());
        }
        
        @Override
        public Aigp nonnullAigp() {
            return Objects.requireNonNullElse(getAigp(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AigpBuilder.empty());
        }
        
        @Override
        public AsPath nonnullAsPath() {
            return Objects.requireNonNullElse(getAsPath(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder.empty());
        }
        
        
        @Override
        public BgpPrefixSid nonnullBgpPrefixSid() {
            return Objects.requireNonNullElse(getBgpPrefixSid(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.BgpPrefixSidBuilder.empty());
        }
        
        
        @Override
        public ClusterId nonnullClusterId() {
            return Objects.requireNonNullElse(getClusterId(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterIdBuilder.empty());
        }
        
        
        
        @Override
        public LocalPref nonnullLocalPref() {
            return Objects.requireNonNullElse(getLocalPref(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPrefBuilder.empty());
        }
        
        @Override
        public MultiExitDisc nonnullMultiExitDisc() {
            return Objects.requireNonNullElse(getMultiExitDisc(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDiscBuilder.empty());
        }
        
        @Override
        public Origin nonnullOrigin() {
            return Objects.requireNonNullElse(getOrigin(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginBuilder.empty());
        }
        
        @Override
        public OriginatorId nonnullOriginatorId() {
            return Objects.requireNonNullElse(getOriginatorId(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorIdBuilder.empty());
        }
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Attributes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Attributes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Attributes.bindingToString(this);
        }
    }
}
