package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpAggregator;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link Aggregator} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Aggregator createAggregator(int fooXyzzy, int barBaz) {
 *         return new AggregatorBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Aggregator, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Aggregator
 *
 */
@Generated("mdsal-binding-generator")
public class AggregatorBuilder {

    private AsNumber _asNumber;
    private Ipv4AddressNoZone _networkAddress;


    Map<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AggregatorBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link BgpAggregator}.
     *
     * @param arg BgpAggregator from which the builder should be initialized
     */
    public AggregatorBuilder(BgpAggregator arg) {
        this._asNumber = arg.getAsNumber();
        this._networkAddress = arg.getNetworkAddress();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Aggregator}.
     *
     * @param base Aggregator from which the builder should be initialized
     */
    public AggregatorBuilder(final Aggregator base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._asNumber = base.getAsNumber();
        this._networkAddress = base.getNetworkAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link BgpAggregator}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpAggregator castArg) {
            this._asNumber = castArg.getAsNumber();
            this._networkAddress = castArg.getNetworkAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BgpAggregator]");
    }

    private static final class LazyEmpty {
        static final @NonNull Aggregator INSTANCE = new AggregatorBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Aggregator.
     *
     * @return An empty {@link Aggregator}
     */
    public static @NonNull Aggregator empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Aggregator#getAsNumber()}.
     *
     * @return current value
     */
    public AsNumber getAsNumber() {
        return _asNumber;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Aggregator#getNetworkAddress()}.
     *
     * @return current value
     */
    public Ipv4AddressNoZone getNetworkAddress() {
        return _networkAddress;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Aggregator>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Aggregator#getAsNumber()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AggregatorBuilder setAsNumber(final AsNumber value) {
        this._asNumber = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Aggregator#getNetworkAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AggregatorBuilder setNetworkAddress(final Ipv4AddressNoZone value) {
        this._networkAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AggregatorBuilder addAugmentation(Augmentation<Aggregator> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AggregatorBuilder removeAugmentation(Class<? extends Augmentation<Aggregator>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Aggregator} instance.
     *
     * @return A new {@link Aggregator} instance.
     */
    public @NonNull Aggregator build() {
        return new AggregatorImpl(this);
    }

    private static final class AggregatorImpl
        extends AbstractAugmentable<Aggregator>
        implements Aggregator {
    
        private final AsNumber _asNumber;
        private final Ipv4AddressNoZone _networkAddress;
    
        AggregatorImpl(final AggregatorBuilder base) {
            super(base.augmentation);
            this._asNumber = base.getAsNumber();
            this._networkAddress = base.getNetworkAddress();
        }
    
        @Override
        public AsNumber getAsNumber() {
            return _asNumber;
        }
        
        @Override
        public Ipv4AddressNoZone getNetworkAddress() {
            return _networkAddress;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Aggregator.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Aggregator.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Aggregator.bindingToString(this);
        }
    }
}
