package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link AsPath} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AsPath createAsPath(int fooXyzzy, int barBaz) {
 *         return new AsPathBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AsPath, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AsPath
 *
 */
@Generated("mdsal-binding-generator")
public class AsPathBuilder {

    private List<Segments> _segments;


    Map<Class<? extends Augmentation<AsPath>>, Augmentation<AsPath>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AsPathBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link AsPath}.
     *
     * @param base AsPath from which the builder should be initialized
     */
    public AsPathBuilder(final AsPath base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._segments = base.getSegments();
    }


    private static final class LazyEmpty {
        static final @NonNull AsPath INSTANCE = new AsPathBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of AsPath.
     *
     * @return An empty {@link AsPath}
     */
    public static @NonNull AsPath empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link AsPath#getSegments()}.
     *
     * @return current value
     */
    public List<Segments> getSegments() {
        return _segments;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AsPath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link AsPath#getSegments()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public AsPathBuilder setSegments(final List<Segments> values) {
        this._segments = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AsPathBuilder addAugmentation(Augmentation<AsPath> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AsPathBuilder removeAugmentation(Class<? extends Augmentation<AsPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link AsPath} instance.
     *
     * @return A new {@link AsPath} instance.
     */
    public @NonNull AsPath build() {
        return new AsPathImpl(this);
    }

    private static final class AsPathImpl
        extends AbstractAugmentable<AsPath>
        implements AsPath {
    
        private final List<Segments> _segments;
    
        AsPathImpl(final AsPathBuilder base) {
            super(base.augmentation);
            this._segments = CodeHelpers.emptyToNull(base.getSegments());
        }
    
        @Override
        public List<Segments> getSegments() {
            return _segments;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AsPath.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AsPath.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AsPath.bindingToString(this);
        }
    }
}
