package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link ExtendedCommunities} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ExtendedCommunities createExtendedCommunities(int fooXyzzy, int barBaz) {
 *         return new ExtendedCommunitiesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ExtendedCommunities, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ExtendedCommunities
 *
 */
@Generated("mdsal-binding-generator")
public class ExtendedCommunitiesBuilder {

    private ExtendedCommunity _extendedCommunity;
    private Boolean _transitive;


    Map<Class<? extends Augmentation<ExtendedCommunities>>, Augmentation<ExtendedCommunities>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ExtendedCommunitiesBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity from which the builder should be initialized
     */
    public ExtendedCommunitiesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity arg) {
        this._transitive = arg.getTransitive();
        this._extendedCommunity = arg.getExtendedCommunity();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link ExtendedCommunities}.
     *
     * @param base ExtendedCommunities from which the builder should be initialized
     */
    public ExtendedCommunitiesBuilder(final ExtendedCommunities base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._extendedCommunity = base.getExtendedCommunity();
        this._transitive = base.getTransitive();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity castArg) {
            this._transitive = castArg.getTransitive();
            this._extendedCommunity = castArg.getExtendedCommunity();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity]");
    }


    /**
     * Return current value associated with the property corresponding to {@link ExtendedCommunities#getExtendedCommunity()}.
     *
     * @return current value
     */
    public ExtendedCommunity getExtendedCommunity() {
        return _extendedCommunity;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ExtendedCommunities#getTransitive()}.
     *
     * @return current value
     */
    public Boolean getTransitive() {
        return _transitive;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ExtendedCommunities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ExtendedCommunities#getExtendedCommunity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ExtendedCommunitiesBuilder setExtendedCommunity(final ExtendedCommunity value) {
        this._extendedCommunity = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ExtendedCommunities#getTransitive()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ExtendedCommunitiesBuilder setTransitive(final Boolean value) {
        this._transitive = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ExtendedCommunitiesBuilder addAugmentation(Augmentation<ExtendedCommunities> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ExtendedCommunitiesBuilder removeAugmentation(Class<? extends Augmentation<ExtendedCommunities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ExtendedCommunities} instance.
     *
     * @return A new {@link ExtendedCommunities} instance.
     */
    public @NonNull ExtendedCommunities build() {
        return new ExtendedCommunitiesImpl(this);
    }

    private static final class ExtendedCommunitiesImpl
        extends AbstractAugmentable<ExtendedCommunities>
        implements ExtendedCommunities {
    
        private final ExtendedCommunity _extendedCommunity;
        private final Boolean _transitive;
    
        ExtendedCommunitiesImpl(final ExtendedCommunitiesBuilder base) {
            super(base.augmentation);
            this._extendedCommunity = base.getExtendedCommunity();
            this._transitive = base.getTransitive();
        }
    
        @Override
        public ExtendedCommunity getExtendedCommunity() {
            return _extendedCommunity;
        }
        
        @Override
        public Boolean getTransitive() {
            return _transitive;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ExtendedCommunities.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ExtendedCommunities.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ExtendedCommunities.bindingToString(this);
        }
    }
}
