package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.bgp.prefix.sid;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.bgp.prefix.sid.bgp.prefix.sid.tlvs.BgpPrefixSidTlv;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;

/**
 * Class that builds {@link BgpPrefixSidTlvs} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BgpPrefixSidTlvs createBgpPrefixSidTlvs(int fooXyzzy, int barBaz) {
 *         return new BgpPrefixSidTlvsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BgpPrefixSidTlvs, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BgpPrefixSidTlvs
 *
 */
@Generated("mdsal-binding-generator")
public class BgpPrefixSidTlvsBuilder {

    private BgpPrefixSidTlv _bgpPrefixSidTlv;


    Map<Class<? extends Augmentation<BgpPrefixSidTlvs>>, Augmentation<BgpPrefixSidTlvs>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public BgpPrefixSidTlvsBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link BgpPrefixSidTlvs}.
     *
     * @param base BgpPrefixSidTlvs from which the builder should be initialized
     */
    public BgpPrefixSidTlvsBuilder(final BgpPrefixSidTlvs base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bgpPrefixSidTlv = base.getBgpPrefixSidTlv();
    }



    /**
     * Return current value associated with the property corresponding to {@link BgpPrefixSidTlvs#getBgpPrefixSidTlv()}.
     *
     * @return current value
     */
    public BgpPrefixSidTlv getBgpPrefixSidTlv() {
        return _bgpPrefixSidTlv;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BgpPrefixSidTlvs>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link BgpPrefixSidTlvs#getBgpPrefixSidTlv()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BgpPrefixSidTlvsBuilder setBgpPrefixSidTlv(final BgpPrefixSidTlv value) {
        this._bgpPrefixSidTlv = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BgpPrefixSidTlvsBuilder addAugmentation(Augmentation<BgpPrefixSidTlvs> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BgpPrefixSidTlvsBuilder removeAugmentation(Class<? extends Augmentation<BgpPrefixSidTlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link BgpPrefixSidTlvs} instance.
     *
     * @return A new {@link BgpPrefixSidTlvs} instance.
     */
    public @NonNull BgpPrefixSidTlvs build() {
        return new BgpPrefixSidTlvsImpl(this);
    }

    private static final class BgpPrefixSidTlvsImpl
        extends AbstractAugmentable<BgpPrefixSidTlvs>
        implements BgpPrefixSidTlvs {
    
        private final BgpPrefixSidTlv _bgpPrefixSidTlv;
    
        BgpPrefixSidTlvsImpl(final BgpPrefixSidTlvsBuilder base) {
            super(base.augmentation);
            this._bgpPrefixSidTlv = base.getBgpPrefixSidTlv();
        }
    
        @Override
        public BgpPrefixSidTlv getBgpPrefixSidTlv() {
            return _bgpPrefixSidTlv;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = BgpPrefixSidTlvs.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return BgpPrefixSidTlvs.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return BgpPrefixSidTlvs.bindingToString(this);
        }
    }
}
