package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Ipv4PrefixAndPathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathIdGrouping;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link WithdrawnRoutes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     WithdrawnRoutes createWithdrawnRoutes(int fooXyzzy, int barBaz) {
 *         return new WithdrawnRoutesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of WithdrawnRoutes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see WithdrawnRoutes
 *
 */
@Generated("mdsal-binding-generator")
public class WithdrawnRoutesBuilder {

    private PathId _pathId;
    private Ipv4Prefix _prefix;


    Map<Class<? extends Augmentation<WithdrawnRoutes>>, Augmentation<WithdrawnRoutes>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public WithdrawnRoutesBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link Ipv4PrefixAndPathId}.
     *
     * @param arg Ipv4PrefixAndPathId from which the builder should be initialized
     */
    public WithdrawnRoutesBuilder(Ipv4PrefixAndPathId arg) {
        this._prefix = arg.getPrefix();
        this._pathId = arg.getPathId();
    }
    
    /**
     * Construct a new builder initialized from specified {@link PathIdGrouping}.
     *
     * @param arg PathIdGrouping from which the builder should be initialized
     */
    public WithdrawnRoutesBuilder(PathIdGrouping arg) {
        this._pathId = arg.getPathId();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link WithdrawnRoutes}.
     *
     * @param base WithdrawnRoutes from which the builder should be initialized
     */
    public WithdrawnRoutesBuilder(final WithdrawnRoutes base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._pathId = base.getPathId();
        this._prefix = base.getPrefix();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PathIdGrouping}</li>
     *   <li>{@link Ipv4PrefixAndPathId}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof PathIdGrouping castArg) {
            this._pathId = castArg.getPathId();
            isValidArg = true;
        }
        if (arg instanceof Ipv4PrefixAndPathId castArg) {
            this._prefix = castArg.getPrefix();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PathIdGrouping, Ipv4PrefixAndPathId]");
    }


    /**
     * Return current value associated with the property corresponding to {@link WithdrawnRoutes#getPathId()}.
     *
     * @return current value
     */
    public PathId getPathId() {
        return _pathId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link WithdrawnRoutes#getPrefix()}.
     *
     * @return current value
     */
    public Ipv4Prefix getPrefix() {
        return _prefix;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<WithdrawnRoutes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link WithdrawnRoutes#getPathId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public WithdrawnRoutesBuilder setPathId(final PathId value) {
        this._pathId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link WithdrawnRoutes#getPrefix()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public WithdrawnRoutesBuilder setPrefix(final Ipv4Prefix value) {
        this._prefix = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public WithdrawnRoutesBuilder addAugmentation(Augmentation<WithdrawnRoutes> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public WithdrawnRoutesBuilder removeAugmentation(Class<? extends Augmentation<WithdrawnRoutes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link WithdrawnRoutes} instance.
     *
     * @return A new {@link WithdrawnRoutes} instance.
     */
    public @NonNull WithdrawnRoutes build() {
        return new WithdrawnRoutesImpl(this);
    }

    private static final class WithdrawnRoutesImpl
        extends AbstractAugmentable<WithdrawnRoutes>
        implements WithdrawnRoutes {
    
        private final PathId _pathId;
        private final Ipv4Prefix _prefix;
    
        WithdrawnRoutesImpl(final WithdrawnRoutesBuilder base) {
            super(base.augmentation);
            this._pathId = base.getPathId();
            this._prefix = base.getPrefix();
        }
    
        @Override
        public PathId getPathId() {
            return _pathId;
        }
        
        @Override
        public Ipv4Prefix getPrefix() {
            return _prefix;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = WithdrawnRoutes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return WithdrawnRoutes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return WithdrawnRoutes.bindingToString(this);
        }
    }
}
