package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.MpReachNlri;

/**
 * Class that builds {@link AttributesReach} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AttributesReach createAttributesReach(int fooXyzzy, int barBaz) {
 *         return new AttributesReachBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AttributesReach, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AttributesReach
 *
 */
@Generated("mdsal-binding-generator")
public class AttributesReachBuilder {

    private MpReachNlri _mpReachNlri;



    /**
     * Construct an empty builder.
     */
    public AttributesReachBuilder() {
        // No-op
    }


    /**
     * Construct a builder initialized with state from specified {@link AttributesReach}.
     *
     * @param base AttributesReach from which the builder should be initialized
     */
    public AttributesReachBuilder(final AttributesReach base) {
        this._mpReachNlri = base.getMpReachNlri();
    }



    /**
     * Return current value associated with the property corresponding to {@link AttributesReach#getMpReachNlri()}.
     *
     * @return current value
     */
    public MpReachNlri getMpReachNlri() {
        return _mpReachNlri;
    }

    
    /**
     * Set the property corresponding to {@link AttributesReach#getMpReachNlri()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesReachBuilder setMpReachNlri(final MpReachNlri value) {
        this._mpReachNlri = value;
        return this;
    }
    

    /**
     * A new {@link AttributesReach} instance.
     *
     * @return A new {@link AttributesReach} instance.
     */
    public @NonNull AttributesReach build() {
        return new AttributesReachImpl(this);
    }

    private static final class AttributesReachImpl
        implements AttributesReach {
    
        private final MpReachNlri _mpReachNlri;
    
        AttributesReachImpl(final AttributesReachBuilder base) {
            this._mpReachNlri = base.getMpReachNlri();
        }
    
        @Override
        public MpReachNlri getMpReachNlri() {
            return _mpReachNlri;
        }
    
        @Override
        public MpReachNlri nonnullMpReachNlri() {
            return Objects.requireNonNullElse(getMpReachNlri(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.MpReachNlriBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AttributesReach.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AttributesReach.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AttributesReach.bindingToString(this);
        }
    }
}
