package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri;

/**
 * Class that builds {@link AttributesUnreach} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AttributesUnreach createAttributesUnreach(int fooXyzzy, int barBaz) {
 *         return new AttributesUnreachBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AttributesUnreach, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AttributesUnreach
 *
 */
@Generated("mdsal-binding-generator")
public class AttributesUnreachBuilder {

    private MpUnreachNlri _mpUnreachNlri;



    /**
     * Construct an empty builder.
     */
    public AttributesUnreachBuilder() {
        // No-op
    }


    /**
     * Construct a builder initialized with state from specified {@link AttributesUnreach}.
     *
     * @param base AttributesUnreach from which the builder should be initialized
     */
    public AttributesUnreachBuilder(final AttributesUnreach base) {
        this._mpUnreachNlri = base.getMpUnreachNlri();
    }



    /**
     * Return current value associated with the property corresponding to {@link AttributesUnreach#getMpUnreachNlri()}.
     *
     * @return current value
     */
    public MpUnreachNlri getMpUnreachNlri() {
        return _mpUnreachNlri;
    }

    
    /**
     * Set the property corresponding to {@link AttributesUnreach#getMpUnreachNlri()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AttributesUnreachBuilder setMpUnreachNlri(final MpUnreachNlri value) {
        this._mpUnreachNlri = value;
        return this;
    }
    

    /**
     * A new {@link AttributesUnreach} instance.
     *
     * @return A new {@link AttributesUnreach} instance.
     */
    public @NonNull AttributesUnreach build() {
        return new AttributesUnreachImpl(this);
    }

    private static final class AttributesUnreachImpl
        implements AttributesUnreach {
    
        private final MpUnreachNlri _mpUnreachNlri;
    
        AttributesUnreachImpl(final AttributesUnreachBuilder base) {
            this._mpUnreachNlri = base.getMpUnreachNlri();
        }
    
        @Override
        public MpUnreachNlri getMpUnreachNlri() {
            return _mpUnreachNlri;
        }
    
        @Override
        public MpUnreachNlri nonnullMpUnreachNlri() {
            return Objects.requireNonNullElse(getMpUnreachNlri(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlriBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AttributesUnreach.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AttributesUnreach.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AttributesUnreach.bindingToString(this);
        }
    }
}
