package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.binding.DataRoot;

/**
 * This module contains the base data model of a BGP message. It rolls up the 
 * definitions contained in RFC4271 and draft-ietf-idr-ls-distribution-03. 
 * Copyright (c)2013 Cisco Systems, Inc. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public 
 * License v1.0 which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * module bgp-multiprotocol {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:bgp-multiprotocol;
 *   prefix bgp-mp;
 *   import bgp-message {
 *     prefix bgp-msg;
 *     revision-date 2020-01-20;
 *   }
 *   import bgp-types {
 *     prefix bgp-t;
 *     revision-date 2020-01-20;
 *   }
 *   import ietf-routing-types {
 *     prefix rt-types;
 *   }
 *   import odl-codegen-extensions {
 *     prefix oce;
 *   }
 *   revision 2018-03-29 {
 *   }
 *   revision 2017-12-07 {
 *   }
 *   revision 2013-09-19 {
 *   }
 *   revision 2013-09-18 {
 *   }
 *   typedef send-receive {
 *     type enumeration {
 *       enum receive {
 *         value 1;
 *       }
 *       enum send {
 *         value 2;
 *       }
 *       enum both {
 *         value 3;
 *       }
 *     }
 *   }
 *   grouping bgp-table-type {
 *     leaf afi {
 *       type identityref {
 *         base address-family;
 *       }
 *     }
 *     leaf safi {
 *       type identityref {
 *         base subsequent-address-family;
 *       }
 *     }
 *   }
 *   grouping bgp-add-path-table-type {
 *     uses bgp-table-type;
 *     leaf send-receive {
 *       type send-receive;
 *     }
 *   }
 *   grouping destination {
 *     choice destination-type;
 *   }
 *   grouping mp-capabilities {
 *     container multiprotocol-capability {
 *       uses bgp-table-type;
 *     }
 *     container graceful-restart-capability {
 *       presence "indicates a graceful restart capability";
 *       leaf restart-flags {
 *         type bits {
 *           bit restart-state {
 *             position 0;
 *           }
 *         }
 *       }
 *       leaf restart-time {
 *         type uint16 {
 *           range 0..4095;
 *         }
 *         units seconds;
 *         default 0;
 *       }
 *       list tables {
 *         uses bgp-table-type;
 *         key "afi safi";
 *         leaf afi-flags {
 *           type bits {
 *             bit forwarding-state {
 *               position 0;
 *             }
 *           }
 *         }
 *       }
 *     }
 *     container ll-graceful-restart-capability {
 *       list tables {
 *         uses bgp-table-type;
 *         key "afi safi";
 *         leaf afi-flags {
 *           type bits {
 *             bit forwarding-state {
 *               position 0;
 *             }
 *           }
 *         }
 *         leaf long-lived-stale-time {
 *           type rt-types:uint24;
 *           units seconds;
 *           default 0;
 *         }
 *       }
 *     }
 *     container add-path-capability {
 *       list address-families {
 *         uses bgp-add-path-table-type;
 *       }
 *     }
 *     container route-refresh-capability {
 *       presence "Route refresh capability";
 *     }
 *   }
 *   augment /bgp-msg:open/bgp-msg:bgp-parameters/bgp-msg:optional-capabilities/bgp-msg:c-parameters {
 *     uses mp-capabilities;
 *   }
 *   augment /bgp-msg:update/bgp-msg:attributes {
 *     oce:augment-identifier attributes-reach;
 *     container mp-reach-nlri {
 *       uses bgp-table-type;
 *       uses bgp-t:next-hop;
 *       container advertized-routes {
 *         uses destination;
 *       }
 *     }
 *   }
 *   augment /bgp-msg:update/bgp-msg:attributes {
 *     oce:augment-identifier attributes-unreach;
 *     container mp-unreach-nlri {
 *       uses bgp-table-type;
 *       container withdrawn-routes {
 *         uses destination;
 *       }
 *     }
 *   }
 *   notification route-refresh {
 *     uses bgp-table-type;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface BgpMultiprotocolData
    extends
    DataRoot<BgpMultiprotocolData>
{




    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpMultiprotocolData> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpMultiprotocolData.class;
    }

}

