package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * grouping bgp-table-type {
 *   leaf afi {
 *     type identityref {
 *       base address-family;
 *     }
 *   }
 *   leaf safi {
 *     type identityref {
 *       base subsequent-address-family;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface BgpTableType
    extends
    Grouping
{




    /**
     * Return afi, or {@code null} if it is not present.
     *
     * @return {@code AddressFamily} afi, or {@code null} if it is not present.
     *
     */
    AddressFamily getAfi();
    
    /**
     * Return afi, guaranteed to be non-null.
     *
     * @return {@code AddressFamily} afi, guaranteed to be non-null.
     * @throws NoSuchElementException if afi is not present
     *
     */
    default @NonNull AddressFamily requireAfi() {
        return CodeHelpers.require(getAfi(), "afi");
    }
    
    /**
     * Return safi, or {@code null} if it is not present.
     *
     * @return {@code SubsequentAddressFamily} safi, or {@code null} if it is not present.
     *
     */
    SubsequentAddressFamily getSafi();
    
    /**
     * Return safi, guaranteed to be non-null.
     *
     * @return {@code SubsequentAddressFamily} safi, guaranteed to be non-null.
     * @throws NoSuchElementException if safi is not present
     *
     */
    default @NonNull SubsequentAddressFamily requireSafi() {
        return CodeHelpers.require(getSafi(), "safi");
    }

}

