package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.AddPathCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.RouteRefreshCapability;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link CParameters1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     CParameters1 createCParameters1(int fooXyzzy, int barBaz) {
 *         return new CParameters1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of CParameters1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see CParameters1
 *
 */
@Generated("mdsal-binding-generator")
public class CParameters1Builder {

    private AddPathCapability _addPathCapability;
    private GracefulRestartCapability _gracefulRestartCapability;
    private LlGracefulRestartCapability _llGracefulRestartCapability;
    private MultiprotocolCapability _multiprotocolCapability;
    private RouteRefreshCapability _routeRefreshCapability;



    /**
     * Construct an empty builder.
     */
    public CParameters1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link MpCapabilities}.
     *
     * @param arg MpCapabilities from which the builder should be initialized
     */
    public CParameters1Builder(MpCapabilities arg) {
        this._multiprotocolCapability = arg.getMultiprotocolCapability();
        this._gracefulRestartCapability = arg.getGracefulRestartCapability();
        this._llGracefulRestartCapability = arg.getLlGracefulRestartCapability();
        this._addPathCapability = arg.getAddPathCapability();
        this._routeRefreshCapability = arg.getRouteRefreshCapability();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link CParameters1}.
     *
     * @param base CParameters1 from which the builder should be initialized
     */
    public CParameters1Builder(final CParameters1 base) {
        this._addPathCapability = base.getAddPathCapability();
        this._gracefulRestartCapability = base.getGracefulRestartCapability();
        this._llGracefulRestartCapability = base.getLlGracefulRestartCapability();
        this._multiprotocolCapability = base.getMultiprotocolCapability();
        this._routeRefreshCapability = base.getRouteRefreshCapability();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link MpCapabilities}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof MpCapabilities castArg) {
            this._multiprotocolCapability = castArg.getMultiprotocolCapability();
            this._gracefulRestartCapability = castArg.getGracefulRestartCapability();
            this._llGracefulRestartCapability = castArg.getLlGracefulRestartCapability();
            this._addPathCapability = castArg.getAddPathCapability();
            this._routeRefreshCapability = castArg.getRouteRefreshCapability();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MpCapabilities]");
    }


    /**
     * Return current value associated with the property corresponding to {@link CParameters1#getAddPathCapability()}.
     *
     * @return current value
     */
    public AddPathCapability getAddPathCapability() {
        return _addPathCapability;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CParameters1#getGracefulRestartCapability()}.
     *
     * @return current value
     */
    public GracefulRestartCapability getGracefulRestartCapability() {
        return _gracefulRestartCapability;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CParameters1#getLlGracefulRestartCapability()}.
     *
     * @return current value
     */
    public LlGracefulRestartCapability getLlGracefulRestartCapability() {
        return _llGracefulRestartCapability;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CParameters1#getMultiprotocolCapability()}.
     *
     * @return current value
     */
    public MultiprotocolCapability getMultiprotocolCapability() {
        return _multiprotocolCapability;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CParameters1#getRouteRefreshCapability()}.
     *
     * @return current value
     */
    public RouteRefreshCapability getRouteRefreshCapability() {
        return _routeRefreshCapability;
    }

    
    /**
     * Set the property corresponding to {@link CParameters1#getAddPathCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CParameters1Builder setAddPathCapability(final AddPathCapability value) {
        this._addPathCapability = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CParameters1#getGracefulRestartCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CParameters1Builder setGracefulRestartCapability(final GracefulRestartCapability value) {
        this._gracefulRestartCapability = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CParameters1#getLlGracefulRestartCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CParameters1Builder setLlGracefulRestartCapability(final LlGracefulRestartCapability value) {
        this._llGracefulRestartCapability = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CParameters1#getMultiprotocolCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CParameters1Builder setMultiprotocolCapability(final MultiprotocolCapability value) {
        this._multiprotocolCapability = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CParameters1#getRouteRefreshCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CParameters1Builder setRouteRefreshCapability(final RouteRefreshCapability value) {
        this._routeRefreshCapability = value;
        return this;
    }
    

    /**
     * A new {@link CParameters1} instance.
     *
     * @return A new {@link CParameters1} instance.
     */
    public @NonNull CParameters1 build() {
        return new CParameters1Impl(this);
    }

    private static final class CParameters1Impl
        implements CParameters1 {
    
        private final AddPathCapability _addPathCapability;
        private final GracefulRestartCapability _gracefulRestartCapability;
        private final LlGracefulRestartCapability _llGracefulRestartCapability;
        private final MultiprotocolCapability _multiprotocolCapability;
        private final RouteRefreshCapability _routeRefreshCapability;
    
        CParameters1Impl(final CParameters1Builder base) {
            this._addPathCapability = base.getAddPathCapability();
            this._gracefulRestartCapability = base.getGracefulRestartCapability();
            this._llGracefulRestartCapability = base.getLlGracefulRestartCapability();
            this._multiprotocolCapability = base.getMultiprotocolCapability();
            this._routeRefreshCapability = base.getRouteRefreshCapability();
        }
    
        @Override
        public AddPathCapability getAddPathCapability() {
            return _addPathCapability;
        }
        
        @Override
        public GracefulRestartCapability getGracefulRestartCapability() {
            return _gracefulRestartCapability;
        }
        
        @Override
        public LlGracefulRestartCapability getLlGracefulRestartCapability() {
            return _llGracefulRestartCapability;
        }
        
        @Override
        public MultiprotocolCapability getMultiprotocolCapability() {
            return _multiprotocolCapability;
        }
        
        @Override
        public RouteRefreshCapability getRouteRefreshCapability() {
            return _routeRefreshCapability;
        }
    
        @Override
        public AddPathCapability nonnullAddPathCapability() {
            return Objects.requireNonNullElse(getAddPathCapability(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.AddPathCapabilityBuilder.empty());
        }
        
        
        @Override
        public LlGracefulRestartCapability nonnullLlGracefulRestartCapability() {
            return Objects.requireNonNullElse(getLlGracefulRestartCapability(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapabilityBuilder.empty());
        }
        
        @Override
        public MultiprotocolCapability nonnullMultiprotocolCapability() {
            return Objects.requireNonNullElse(getMultiprotocolCapability(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapabilityBuilder.empty());
        }
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = CParameters1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return CParameters1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return CParameters1.bindingToString(this);
        }
    }
}
