package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.AddPathCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.RouteRefreshCapability;
import org.opendaylight.yangtools.binding.Grouping;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * grouping mp-capabilities {
 *   container multiprotocol-capability {
 *     uses bgp-table-type;
 *   }
 *   container graceful-restart-capability {
 *     presence "indicates a graceful restart capability";
 *     leaf restart-flags {
 *       type bits {
 *         bit restart-state {
 *           position 0;
 *         }
 *       }
 *     }
 *     leaf restart-time {
 *       type uint16 {
 *         range 0..4095;
 *       }
 *       units seconds;
 *       default 0;
 *     }
 *     list tables {
 *       uses bgp-table-type;
 *       key "afi safi";
 *       leaf afi-flags {
 *         type bits {
 *           bit forwarding-state {
 *             position 0;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   container ll-graceful-restart-capability {
 *     list tables {
 *       uses bgp-table-type;
 *       key "afi safi";
 *       leaf afi-flags {
 *         type bits {
 *           bit forwarding-state {
 *             position 0;
 *           }
 *         }
 *       }
 *       leaf long-lived-stale-time {
 *         type rt-types:uint24;
 *         units seconds;
 *         default 0;
 *       }
 *     }
 *   }
 *   container add-path-capability {
 *     list address-families {
 *       uses bgp-add-path-table-type;
 *     }
 *   }
 *   container route-refresh-capability {
 *     presence "Route refresh capability";
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface MpCapabilities
    extends
    Grouping
{




    /**
     * Return multiprotocolCapability, or {@code null} if it is not present.
     *
     * @return {@code MultiprotocolCapability} multiprotocolCapability, or {@code null} if it is not present.
     *
     */
    MultiprotocolCapability getMultiprotocolCapability();
    
    /**
     * Return multiprotocolCapability, or an empty instance if it is not present.
     *
     * @return {@code MultiprotocolCapability} multiprotocolCapability, or an empty instance if it is not present.
     *
     */
    @NonNull MultiprotocolCapability nonnullMultiprotocolCapability();
    
    /**
     * Return gracefulRestartCapability, or {@code null} if it is not present.
     *
     * @return {@code GracefulRestartCapability} gracefulRestartCapability, or {@code null} if it is not present.
     *
     */
    GracefulRestartCapability getGracefulRestartCapability();
    
    /**
     * Return llGracefulRestartCapability, or {@code null} if it is not present.
     *
     * @return {@code LlGracefulRestartCapability} llGracefulRestartCapability, or {@code null} if it is not present.
     *
     */
    LlGracefulRestartCapability getLlGracefulRestartCapability();
    
    /**
     * Return llGracefulRestartCapability, or an empty instance if it is not present.
     *
     * @return {@code LlGracefulRestartCapability} llGracefulRestartCapability, or an empty instance if it is not present.
     *
     */
    @NonNull LlGracefulRestartCapability nonnullLlGracefulRestartCapability();
    
    /**
     * Return addPathCapability, or {@code null} if it is not present.
     *
     * @return {@code AddPathCapability} addPathCapability, or {@code null} if it is not present.
     *
     */
    AddPathCapability getAddPathCapability();
    
    /**
     * Return addPathCapability, or an empty instance if it is not present.
     *
     * @return {@code AddPathCapability} addPathCapability, or an empty instance if it is not present.
     *
     */
    @NonNull AddPathCapability nonnullAddPathCapability();
    
    /**
     * Return routeRefreshCapability, or {@code null} if it is not present.
     *
     * @return {@code RouteRefreshCapability} routeRefreshCapability, or {@code null} if it is not present.
     *
     */
    RouteRefreshCapability getRouteRefreshCapability();

}

