package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.EnumTypeObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * typedef send-receive {
 *   type enumeration {
 *     enum receive {
 *       value 1;
 *     }
 *     enum send {
 *       value 2;
 *     }
 *     enum both {
 *       value 3;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum SendReceive implements EnumTypeObject {
    Receive(1, "receive"),
    
    Send(2, "send"),
    
    Both(3, "both")
    ;

    private final @NonNull String name;
    private final int value;

    private SendReceive(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding SendReceive item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable SendReceive forName(String name) {
        return switch (name) {
            case "receive" -> Receive;
            case "send" -> Send;
            case "both" -> Both;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding SendReceive item, or {@code null} if no such item exists
     */
    public static @Nullable SendReceive forValue(int intValue) {
        return switch (intValue) {
            case 1 -> Receive;
            case 2 -> Send;
            case 3 -> Both;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding SendReceive item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull SendReceive ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding SendReceive item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull SendReceive ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
