package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.AttributesUnreach;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.mp.unreach.nlri.WithdrawnRoutes;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * container mp-unreach-nlri {
 *   uses bgp-table-type;
 *   container withdrawn-routes {
 *     uses destination;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MpUnreachNlriBuilder}.
 * @see MpUnreachNlriBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface MpUnreachNlri
    extends
    ChildOf<AttributesUnreach>,
    Augmentable<MpUnreachNlri>,
    BgpTableType
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("mp-unreach-nlri");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.@NonNull MpUnreachNlri obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAfi());
        result = prime * result + Objects.hashCode(obj.getSafi());
        result = prime * result + Objects.hashCode(obj.getWithdrawnRoutes());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.@NonNull MpUnreachNlri thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri.class, obj);
        return other != null
            && Objects.equals(thisObj.getAfi(), other.getAfi())
            && Objects.equals(thisObj.getSafi(), other.getSafi())
            && Objects.equals(thisObj.getWithdrawnRoutes(), other.getWithdrawnRoutes())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.@NonNull MpUnreachNlri obj) {
        final var helper = MoreObjects.toStringHelper("MpUnreachNlri");
        CodeHelpers.appendValue(helper, "afi", obj.getAfi());
        CodeHelpers.appendValue(helper, "safi", obj.getSafi());
        CodeHelpers.appendValue(helper, "withdrawnRoutes", obj.getWithdrawnRoutes());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return withdrawnRoutes, or {@code null} if it is not present.
     *
     * @return {@code WithdrawnRoutes} withdrawnRoutes, or {@code null} if it is not present.
     *
     */
    WithdrawnRoutes getWithdrawnRoutes();
    
    /**
     * Return withdrawnRoutes, or an empty instance if it is not present.
     *
     * @return {@code WithdrawnRoutes} withdrawnRoutes, or an empty instance if it is not present.
     *
     */
    @NonNull WithdrawnRoutes nonnullWithdrawnRoutes();

}

