package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.mp.unreach.nlri.WithdrawnRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link MpUnreachNlri} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MpUnreachNlri createMpUnreachNlri(int fooXyzzy, int barBaz) {
 *         return new MpUnreachNlriBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MpUnreachNlri, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MpUnreachNlri
 *
 */
@Generated("mdsal-binding-generator")
public class MpUnreachNlriBuilder {

    private AddressFamily _afi;
    private SubsequentAddressFamily _safi;
    private WithdrawnRoutes _withdrawnRoutes;


    Map<Class<? extends Augmentation<MpUnreachNlri>>, Augmentation<MpUnreachNlri>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public MpUnreachNlriBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link BgpTableType}.
     *
     * @param arg BgpTableType from which the builder should be initialized
     */
    public MpUnreachNlriBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link MpUnreachNlri}.
     *
     * @param base MpUnreachNlri from which the builder should be initialized
     */
    public MpUnreachNlriBuilder(final MpUnreachNlri base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._withdrawnRoutes = base.getWithdrawnRoutes();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link BgpTableType}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType castArg) {
            this._afi = castArg.getAfi();
            this._safi = castArg.getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BgpTableType]");
    }

    private static final class LazyEmpty {
        static final @NonNull MpUnreachNlri INSTANCE = new MpUnreachNlriBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of MpUnreachNlri.
     *
     * @return An empty {@link MpUnreachNlri}
     */
    public static @NonNull MpUnreachNlri empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link MpUnreachNlri#getAfi()}.
     *
     * @return current value
     */
    public AddressFamily getAfi() {
        return _afi;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link MpUnreachNlri#getSafi()}.
     *
     * @return current value
     */
    public SubsequentAddressFamily getSafi() {
        return _safi;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link MpUnreachNlri#getWithdrawnRoutes()}.
     *
     * @return current value
     */
    public WithdrawnRoutes getWithdrawnRoutes() {
        return _withdrawnRoutes;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MpUnreachNlri>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link MpUnreachNlri#getAfi()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MpUnreachNlriBuilder setAfi(final AddressFamily value) {
        this._afi = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link MpUnreachNlri#getSafi()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MpUnreachNlriBuilder setSafi(final SubsequentAddressFamily value) {
        this._safi = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link MpUnreachNlri#getWithdrawnRoutes()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MpUnreachNlriBuilder setWithdrawnRoutes(final WithdrawnRoutes value) {
        this._withdrawnRoutes = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MpUnreachNlriBuilder addAugmentation(Augmentation<MpUnreachNlri> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MpUnreachNlriBuilder removeAugmentation(Class<? extends Augmentation<MpUnreachNlri>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link MpUnreachNlri} instance.
     *
     * @return A new {@link MpUnreachNlri} instance.
     */
    public @NonNull MpUnreachNlri build() {
        return new MpUnreachNlriImpl(this);
    }

    private static final class MpUnreachNlriImpl
        extends AbstractAugmentable<MpUnreachNlri>
        implements MpUnreachNlri {
    
        private final AddressFamily _afi;
        private final SubsequentAddressFamily _safi;
        private final WithdrawnRoutes _withdrawnRoutes;
    
        MpUnreachNlriImpl(final MpUnreachNlriBuilder base) {
            super(base.augmentation);
            this._afi = base.getAfi();
            this._safi = base.getSafi();
            this._withdrawnRoutes = base.getWithdrawnRoutes();
        }
    
        @Override
        public AddressFamily getAfi() {
            return _afi;
        }
        
        @Override
        public SubsequentAddressFamily getSafi() {
            return _safi;
        }
        
        @Override
        public WithdrawnRoutes getWithdrawnRoutes() {
            return _withdrawnRoutes;
        }
    
        
        
        @Override
        public WithdrawnRoutes nonnullWithdrawnRoutes() {
            return Objects.requireNonNullElse(getWithdrawnRoutes(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.mp.unreach.nlri.WithdrawnRoutesBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = MpUnreachNlri.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return MpUnreachNlri.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return MpUnreachNlri.bindingToString(this);
        }
    }
}
