package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.MpCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.TablesKey;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * container ll-graceful-restart-capability {
 *   list tables {
 *     uses bgp-table-type;
 *     key "afi safi";
 *     leaf afi-flags {
 *       type bits {
 *         bit forwarding-state {
 *           position 0;
 *         }
 *       }
 *     }
 *     leaf long-lived-stale-time {
 *       type rt-types:uint24;
 *       units seconds;
 *       default 0;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link LlGracefulRestartCapabilityBuilder}.
 * @see LlGracefulRestartCapabilityBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface LlGracefulRestartCapability
    extends
    ChildOf<MpCapabilities>,
    Augmentable<LlGracefulRestartCapability>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ll-graceful-restart-capability");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.@NonNull LlGracefulRestartCapability obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getTables());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.@NonNull LlGracefulRestartCapability thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability.class, obj);
        return other != null
            && Objects.equals(thisObj.getTables(), other.getTables())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.@NonNull LlGracefulRestartCapability obj) {
        final var helper = MoreObjects.toStringHelper("LlGracefulRestartCapability");
        CodeHelpers.appendValue(helper, "tables", obj.getTables());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return tables, or {@code null} if it is not present.
     *
     * @return {@code Map<TablesKey, Tables>} tables, or {@code null} if it is not present.
     *
     */
    @Nullable Map<TablesKey, Tables> getTables();
    
    /**
     * Return tables, or an empty list if it is not present.
     *
     * @return {@code Map<TablesKey, Tables>} tables, or an empty list if it is not present.
     *
     */
    default @NonNull Map<TablesKey, Tables> nonnullTables() {
        return CodeHelpers.nonnull(getTables());
    }

}

