package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.routing.types.rev171204.Uint24;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.BitsTypeObject;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
 * <pre>
 * list tables {
 *   uses bgp-table-type;
 *   key "afi safi";
 *   leaf afi-flags {
 *     type bits {
 *       bit forwarding-state {
 *         position 0;
 *       }
 *     }
 *   }
 *   leaf long-lived-stale-time {
 *     type rt-types:uint24;
 *     units seconds;
 *     default 0;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link TablesBuilder}.
 * @see TablesBuilder
 * @see TablesKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Tables
    extends
    ChildOf<LlGracefulRestartCapability>,
    BgpTableType,
    EntryObject<Tables, TablesKey>
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>bgp-multiprotocol</b>
     * <pre>
     * leaf afi-flags {
     *   type bits {
     *     bit forwarding-state {
     *       position 0;
     *     }
     *   }
     * }
     * </pre>
     *
     */
    public static final class AfiFlags
     implements BitsTypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = 8494451692068161343L;
        protected static final ImmutableSet<String> VALID_NAMES = ImmutableSet.of("forwarding-state");
        private final boolean _forwardingState;
    
    
        public AfiFlags(boolean _forwardingState) {
        
            this._forwardingState = _forwardingState;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public AfiFlags(AfiFlags source) {
            this._forwardingState = source._forwardingState;
        }
    
    
        public boolean getForwardingState() {
            return _forwardingState;
        }
    
        
        @Override
        public ImmutableSet<String> validNames() {
            return VALID_NAMES;
        }
        
        @Override
        public boolean[] values() {
            return new boolean[] {
                    getForwardingState()
                };
        }
    
        @Override
        public int hashCode() {
            return Boolean.hashCode(_forwardingState);
        }
    
        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj instanceof AfiFlags other
                && _forwardingState == other._forwardingState;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(AfiFlags.class);
            CodeHelpers.appendBit(helper, "forwardingState", _forwardingState);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("tables");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.@NonNull Tables obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAfi());
        result = prime * result + Objects.hashCode(obj.getAfiFlags());
        result = prime * result + Objects.hashCode(obj.getLongLivedStaleTime());
        result = prime * result + Objects.hashCode(obj.getSafi());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.@NonNull Tables thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables.class, obj);
        return other != null
            && Objects.equals(thisObj.getAfi(), other.getAfi())
            && Objects.equals(thisObj.getLongLivedStaleTime(), other.getLongLivedStaleTime())
            && Objects.equals(thisObj.getSafi(), other.getSafi())
            && Objects.equals(thisObj.getAfiFlags(), other.getAfiFlags())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.@NonNull Tables obj) {
        final var helper = MoreObjects.toStringHelper("Tables");
        CodeHelpers.appendValue(helper, "afi", obj.getAfi());
        CodeHelpers.appendValue(helper, "afiFlags", obj.getAfiFlags());
        CodeHelpers.appendValue(helper, "longLivedStaleTime", obj.getLongLivedStaleTime());
        CodeHelpers.appendValue(helper, "safi", obj.getSafi());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    TablesKey key();
    
    /**
     * Return afiFlags, or {@code null} if it is not present.
     *
     * @return {@code AfiFlags} afiFlags, or {@code null} if it is not present.
     *
     */
    AfiFlags getAfiFlags();
    
    /**
     * Return afiFlags, guaranteed to be non-null.
     *
     * @return {@code AfiFlags} afiFlags, guaranteed to be non-null.
     * @throws NoSuchElementException if afiFlags is not present
     *
     */
    default @NonNull AfiFlags requireAfiFlags() {
        return CodeHelpers.require(getAfiFlags(), "afiflags");
    }
    
    /**
     * Return longLivedStaleTime, or {@code null} if it is not present.
     *
     * @return {@code Uint24} longLivedStaleTime, or {@code null} if it is not present.
     *
     */
    Uint24 getLongLivedStaleTime();
    
    /**
     * Return longLivedStaleTime, guaranteed to be non-null.
     *
     * @return {@code Uint24} longLivedStaleTime, guaranteed to be non-null.
     * @throws NoSuchElementException if longLivedStaleTime is not present
     *
     */
    default @NonNull Uint24 requireLongLivedStaleTime() {
        return CodeHelpers.require(getLongLivedStaleTime(), "longlivedstaletime");
    }

}

