package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.routing.types.rev171204.Uint24;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link Tables} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Tables createTables(int fooXyzzy, int barBaz) {
 *         return new TablesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Tables, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Tables
 *
 */
@Generated("mdsal-binding-generator")
public class TablesBuilder {

    private AddressFamily _afi;
    private Tables.AfiFlags _afiFlags;
    private Uint24 _longLivedStaleTime;
    private SubsequentAddressFamily _safi;
    private TablesKey key;


    Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TablesBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link BgpTableType}.
     *
     * @param arg BgpTableType from which the builder should be initialized
     */
    public TablesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Tables}.
     *
     * @param base Tables from which the builder should be initialized
     */
    public TablesBuilder(final Tables base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._afiFlags = base.getAfiFlags();
        this._longLivedStaleTime = base.getLongLivedStaleTime();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link BgpTableType}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType castArg) {
            this._afi = castArg.getAfi();
            this._safi = castArg.getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BgpTableType]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Tables#key()}.
     *
     * @return current value
     */
    public TablesKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tables#getAfi()}.
     *
     * @return current value
     */
    public AddressFamily getAfi() {
        return _afi;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tables#getAfiFlags()}.
     *
     * @return current value
     */
    public Tables.AfiFlags getAfiFlags() {
        return _afiFlags;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tables#getLongLivedStaleTime()}.
     *
     * @return current value
     */
    public Uint24 getLongLivedStaleTime() {
        return _longLivedStaleTime;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Tables#getSafi()}.
     *
     * @return current value
     */
    public SubsequentAddressFamily getSafi() {
        return _safi;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Tables>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Tables#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public TablesBuilder withKey(final TablesKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tables#getAfi()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TablesBuilder setAfi(final AddressFamily value) {
        this._afi = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tables#getAfiFlags()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TablesBuilder setAfiFlags(final Tables.AfiFlags value) {
        this._afiFlags = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tables#getLongLivedStaleTime()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TablesBuilder setLongLivedStaleTime(final Uint24 value) {
        this._longLivedStaleTime = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Tables#getSafi()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TablesBuilder setSafi(final SubsequentAddressFamily value) {
        this._safi = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TablesBuilder addAugmentation(Augmentation<Tables> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TablesBuilder removeAugmentation(Class<? extends Augmentation<Tables>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Tables} instance.
     *
     * @return A new {@link Tables} instance.
     */
    public @NonNull Tables build() {
        return new TablesImpl(this);
    }

    private static final class TablesImpl
        extends AbstractEntryObject<Tables, TablesKey>
        implements Tables {
    
        private final AddressFamily _afi;
        private final Tables.AfiFlags _afiFlags;
        private final Uint24 _longLivedStaleTime;
        private final SubsequentAddressFamily _safi;
    
        TablesImpl(final TablesBuilder base) {
            super(base.augmentation, extractKey(base));
            final var key = key();
            this._afi = key.getAfi();
            this._safi = key.getSafi();
            this._afiFlags = base.getAfiFlags();
            this._longLivedStaleTime = base.getLongLivedStaleTime();
        }
        
        private static @NonNull TablesKey extractKey(final TablesBuilder base) {
            final var key = base.key();
            return key != null ? key
                : new TablesKey(base.getAfi(), base.getSafi());
        }
    
        @Override
        public AddressFamily getAfi() {
            return _afi;
        }
        
        @Override
        public Tables.AfiFlags getAfiFlags() {
            return _afiFlags;
        }
        
        @Override
        public Uint24 getLongLivedStaleTime() {
            return _longLivedStaleTime;
        }
        
        @Override
        public SubsequentAddressFamily getSafi() {
            return _safi;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Tables.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Tables.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Tables.bindingToString(this);
        }
    }
}
