package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * This class represents the key of {@link Tables} class.
 *
 * @see Tables
 *
 */
@Generated("mdsal-binding-generator")
public final class TablesKey
 implements Key<Tables> {
    @java.io.Serial
    private static final long serialVersionUID = -1249878086522103713L;
    private final AddressFamily _afi;
    private final SubsequentAddressFamily _safi;


    /**
     * Constructs an instance.
     *
     * @param _afi the entity afi
     * @param _safi the entity safi
     * @throws NullPointerException if any of the arguments are null
     */
    public TablesKey(@NonNull AddressFamily _afi, @NonNull SubsequentAddressFamily _safi) {
        this._afi = CodeHelpers.requireKeyProp(_afi, "afi");
        this._safi = CodeHelpers.requireKeyProp(_safi, "safi");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public TablesKey(TablesKey source) {
        this._afi = source._afi;
        this._safi = source._safi;
    }


    /**
     * Return afi, guaranteed to be non-null.
     *
     * @return {@code AddressFamily} afi, guaranteed to be non-null.
     */
    public @NonNull AddressFamily getAfi() {
        return _afi;
    }
    
    /**
     * Return safi, guaranteed to be non-null.
     *
     * @return {@code SubsequentAddressFamily} safi, guaranteed to be non-null.
     */
    public @NonNull SubsequentAddressFamily getSafi() {
        return _safi;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_afi);
        result = prime * result + Objects.hashCode(_safi);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof TablesKey other
            && Objects.equals(_afi, other._afi)        
            && Objects.equals(_safi, other._safi);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(TablesKey.class);
        CodeHelpers.appendValue(helper, "afi", _afi);
        CodeHelpers.appendValue(helper, "safi", _safi);
        return helper.toString();
    }
}

