/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupportUtil;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParsedAttributes;
import org.opendaylight.protocol.bgp.parser.spi.PathIdUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.Ipv4PrefixAndPathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.UpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.update.message.NlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.update.message.WithdrawnRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.update.message.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes2Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BGPUpdateMessageParser
implements MessageParser,
MessageSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(BGPUpdateMessageParser.class);
    public static final int TYPE = 2;
    private static final int WITHDRAWN_ROUTES_LENGTH_SIZE = 2;
    private static final int TOTAL_PATH_ATTR_LENGTH_SIZE = 2;
    private final AttributeRegistry attrReg;
    private final NlriRegistry nlriReg;

    public BGPUpdateMessageParser(AttributeRegistry attrReg, NlriRegistry nlriReg) {
        this.attrReg = Objects.requireNonNull(attrReg);
        this.nlriReg = Objects.requireNonNull(nlriReg);
    }

    public void serializeMessage(Notification message, ByteBuf bytes) {
        Preconditions.checkArgument((boolean)(message instanceof Update), (Object)"Message needs to be of type Update");
        Update update = (Update)message;
        ByteBuf messageBody = Unpooled.buffer();
        List withdrawnRoutes = update.getWithdrawnRoutes();
        if (withdrawnRoutes != null) {
            ByteBuf withdrawnRoutesBuf = Unpooled.buffer();
            withdrawnRoutes.forEach(withdrawnRoute -> BGPUpdateMessageParser.writePathIdPrefix(withdrawnRoutesBuf, withdrawnRoute.getPathId(), withdrawnRoute.getPrefix()));
            messageBody.writeShort(withdrawnRoutesBuf.writerIndex());
            messageBody.writeBytes(withdrawnRoutesBuf);
        } else {
            messageBody.writeZero(2);
        }
        if (update.getAttributes() != null) {
            ByteBuf pathAttributesBuf = Unpooled.buffer();
            this.attrReg.serializeAttribute(update.getAttributes(), pathAttributesBuf);
            messageBody.writeShort(pathAttributesBuf.writerIndex());
            messageBody.writeBytes(pathAttributesBuf);
        } else {
            messageBody.writeZero(2);
        }
        List nlris = update.getNlri();
        if (nlris != null) {
            nlris.forEach(nlri -> BGPUpdateMessageParser.writePathIdPrefix(messageBody, nlri.getPathId(), nlri.getPrefix()));
        }
        MessageUtil.formatMessage((int)2, (ByteBuf)messageBody, (ByteBuf)bytes);
    }

    private static void writePathIdPrefix(ByteBuf byteBuf, PathId pathId, Ipv4Prefix ipv4Prefix) {
        PathIdUtil.writePathId((PathId)pathId, (ByteBuf)byteBuf);
        ByteBufWriteUtil.writeMinimalPrefix((Ipv4Prefix)ipv4Prefix, (ByteBuf)byteBuf);
    }

    public Update parseMessageBody(ByteBuf buffer, int messageLength, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        Optional<BGPTreatAsWithdrawException> withdrawCauseOpt;
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Buffer cannot be null or empty.");
        UpdateBuilder builder = new UpdateBuilder();
        boolean isMultiPathSupported = MultiPathSupportUtil.isTableTypeSupported((PeerSpecificParserConstraint)constraint, (BgpTableType)new BgpTableTypeImpl(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class));
        RevisedErrorHandling errorHandling = RevisedErrorHandling.from((PeerSpecificParserConstraint)constraint);
        int withdrawnRoutesLength = buffer.readUnsignedShort();
        if (withdrawnRoutesLength > 0) {
            ArrayList<WithdrawnRoutes> withdrawnRoutes = new ArrayList<WithdrawnRoutes>();
            ByteBuf withdrawnRoutesBuffer = buffer.readBytes(withdrawnRoutesLength);
            while (withdrawnRoutesBuffer.isReadable()) {
                WithdrawnRoutesBuilder withdrawnRoutesBuilder = new WithdrawnRoutesBuilder();
                if (isMultiPathSupported) {
                    withdrawnRoutesBuilder.setPathId(PathIdUtil.readPathId((ByteBuf)withdrawnRoutesBuffer));
                }
                withdrawnRoutesBuilder.setPrefix(BGPUpdateMessageParser.readPrefix(withdrawnRoutesBuffer, errorHandling, "Withdrawn Routes"));
                withdrawnRoutes.add(withdrawnRoutesBuilder.build());
            }
            withdrawnRoutesBuffer.release();
            builder.setWithdrawnRoutes(withdrawnRoutes);
        }
        int totalPathAttrLength = buffer.readUnsignedShort();
        if (withdrawnRoutesLength == 0 && totalPathAttrLength == 0) {
            return builder.build();
        }
        if (totalPathAttrLength > 0) {
            ParsedAttributes attributes = this.parseAttributes(buffer, totalPathAttrLength, constraint);
            builder.setAttributes(attributes.getAttributes());
            withdrawCauseOpt = attributes.getWithdrawCause();
        } else {
            withdrawCauseOpt = Optional.empty();
        }
        ArrayList<Nlri> nlri = new ArrayList<Nlri>();
        while (buffer.isReadable()) {
            NlriBuilder nlriBuilder = new NlriBuilder();
            if (isMultiPathSupported) {
                nlriBuilder.setPathId(PathIdUtil.readPathId((ByteBuf)buffer));
            }
            nlriBuilder.setPrefix(BGPUpdateMessageParser.readPrefix(buffer, errorHandling, "NLRI"));
            nlri.add(nlriBuilder.build());
        }
        if (!nlri.isEmpty()) {
            builder.setNlri(nlri);
        }
        try {
            BGPUpdateMessageParser.checkMandatoryAttributesPresence(builder.build(), errorHandling);
        }
        catch (BGPTreatAsWithdrawException e) {
            LOG.debug("Well-known mandatory attributes missing", (Throwable)e);
            if (withdrawCauseOpt.isPresent()) {
                BGPTreatAsWithdrawException exception = (BGPTreatAsWithdrawException)((Object)withdrawCauseOpt.get());
                exception.addSuppressed((Throwable)e);
                withdrawCauseOpt = Optional.of(exception);
            }
            withdrawCauseOpt = Optional.of(e);
        }
        Update msg = builder.build();
        if (withdrawCauseOpt.isPresent()) {
            msg = this.withdrawUpdate(msg, errorHandling, withdrawCauseOpt.get());
        }
        LOG.debug("BGP Update message was parsed {}.", (Object)msg);
        return msg;
    }

    private ParsedAttributes parseAttributes(ByteBuf buffer, int totalPathAttrLength, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        try {
            return this.attrReg.parseAttributes(buffer.readSlice(totalPathAttrLength), constraint);
        }
        catch (RuntimeException | BGPParsingException e) {
            throw new BGPDocumentedException("Could not parse BGP attributes.", BGPError.MALFORMED_ATTR_LIST, (Exception)e);
        }
    }

    private static Ipv4Prefix readPrefix(ByteBuf buf, RevisedErrorHandling errorHandling, String fieldName) throws BGPDocumentedException {
        short prefixLength = buf.readUnsignedByte();
        if (errorHandling != RevisedErrorHandling.NONE) {
            if (prefixLength > 32) {
                throw new BGPDocumentedException(fieldName + " length " + prefixLength + " exceeds 32 bytes", BGPError.ATTR_LENGTH_ERROR);
            }
            if (prefixLength > buf.readableBytes() * 8) {
                throw new BGPDocumentedException(fieldName + " length " + prefixLength + " exceeds unconsumed field space", BGPError.ATTR_LENGTH_ERROR);
            }
        }
        return Ipv4Util.prefixForByteBuf((ByteBuf)buf, (int)prefixLength);
    }

    private static void checkMandatoryAttributesPresence(Update message, RevisedErrorHandling errorHandling) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        Objects.requireNonNull(message, "Update message cannot be null");
        Attributes attrs = message.getAttributes();
        if (message.getNlri() != null && (attrs == null || attrs.getCNextHop() == null)) {
            throw BGPUpdateMessageParser.reportMissingAttribute(errorHandling, "NEXT_HOP", 3);
        }
        if (MessageUtil.isAnyNlriPresent((Update)message)) {
            if (attrs == null || attrs.getOrigin() == null) {
                throw BGPUpdateMessageParser.reportMissingAttribute(errorHandling, "ORIGIN", 1);
            }
            if (attrs.getAsPath() == null) {
                throw BGPUpdateMessageParser.reportMissingAttribute(errorHandling, "AS_PATH", 2);
            }
        }
    }

    private static BGPDocumentedException reportMissingAttribute(RevisedErrorHandling errorHandling, String attrName, int attrType) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        return errorHandling.reportError(BGPError.WELL_KNOWN_ATTR_MISSING, new byte[]{(byte)attrType}, "Well known mandatory attribute missing: %s", new Object[]{attrName});
    }

    private Update withdrawUpdate(Update parsed, RevisedErrorHandling errorHandling, BGPTreatAsWithdrawException withdrawCause) throws BGPDocumentedException {
        if (errorHandling == RevisedErrorHandling.NONE) {
            throw new BGPDocumentedException(withdrawCause);
        }
        LOG.debug("Converting BGP Update message {} to withdraw", (Object)parsed, (Object)withdrawCause);
        UpdateBuilder builder = new UpdateBuilder();
        List nlris = parsed.getNlri();
        List withdrawn = nlris != null && !nlris.isEmpty() ? (List)Streams.concat((Stream[])new Stream[]{parsed.nonnullWithdrawnRoutes().stream(), nlris.stream().map(nlri -> new WithdrawnRoutesBuilder((Ipv4PrefixAndPathId)nlri).build())}).collect(ImmutableList.toImmutableList()) : parsed.getWithdrawnRoutes();
        builder.setWithdrawnRoutes(withdrawn);
        Attributes attributes = parsed.getAttributes();
        if (attributes != null) {
            builder.setAttributes(this.withdrawAttributes(attributes, withdrawCause));
        }
        return builder.build();
    }

    private Attributes withdrawAttributes(Attributes parsed, BGPTreatAsWithdrawException withdrawCause) throws BGPDocumentedException {
        TablesKey unreachKey;
        TablesKey reachKey;
        AttributesBuilder builder = new AttributesBuilder();
        MpReachNlri mpReachNlri = BGPUpdateMessageParser.getMpReach(parsed);
        if (mpReachNlri == null) {
            builder.addAugmentation(Attributes2.class, parsed.augmentation(Attributes2.class));
            return builder.build();
        }
        MpUnreachNlri unreachNlri = BGPUpdateMessageParser.getMpUnreach(parsed);
        if (unreachNlri != null && !(reachKey = new TablesKey(mpReachNlri.getAfi(), mpReachNlri.getSafi())).equals((Object)(unreachKey = new TablesKey(unreachNlri.getAfi(), unreachNlri.getSafi())))) {
            LOG.warn("Unexpected mismatch between MP_REACH ({}) and MP_UNREACH ({})", new Object[]{reachKey, unreachKey, withdrawCause});
            throw new BGPDocumentedException(withdrawCause);
        }
        MpUnreachNlri converted = (MpUnreachNlri)this.nlriReg.convertMpReachToMpUnReach(mpReachNlri, unreachNlri).orElseThrow(() -> {
            LOG.warn("Could not convert attributes {} to withdraw attributes", (Object)parsed, (Object)withdrawCause);
            return new BGPDocumentedException(withdrawCause);
        });
        builder.addAugmentation(Attributes2.class, (Augmentation)new Attributes2Builder().setMpUnreachNlri(converted).build());
        return builder.build();
    }

    private static MpReachNlri getMpReach(Attributes attrs) {
        Attributes1 reachAttr = (Attributes1)attrs.augmentation(Attributes1.class);
        return reachAttr == null ? null : reachAttr.getMpReachNlri();
    }

    private static MpUnreachNlri getMpUnreach(Attributes attrs) {
        Attributes2 unreachAttr = (Attributes2)attrs.augmentation(Attributes2.class);
        return unreachAttr == null ? null : unreachAttr.getMpUnreachNlri();
    }
}

