/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BgpExtendedMessageUtil;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.c.parameters.BgpExtendedMessageCapability;

public final class BgpExtendedMessageCapabilityHandler
implements CapabilityParser,
CapabilitySerializer {
    public static final int CODE = 6;

    public CParameters parseCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        return BgpExtendedMessageUtil.EXTENDED_MESSAGE_CAPABILITY;
    }

    public void serializeCapability(CParameters capability, ByteBuf byteAggregator) {
        BgpExtendedMessageCapability bgpExtendedMessageCapability = capability.getBgpExtendedMessageCapability();
        if (bgpExtendedMessageCapability != null) {
            CapabilityUtil.formatCapability((int)6, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)byteAggregator);
        }
    }
}

