/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvRegistry;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.BgpPrefixSid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.BgpPrefixSidBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.bgp.prefix.sid.BgpPrefixSidTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.bgp.prefix.sid.BgpPrefixSidTlvsBuilder;

public final class BgpPrefixSidAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 40;
    private final BgpPrefixSidTlvRegistry reg;

    public BgpPrefixSidAttributeParser(BgpPrefixSidTlvRegistry registry) {
        this.reg = Objects.requireNonNull(registry);
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        BgpPrefixSid prefixSid = pathAttributes.getBgpPrefixSid();
        if (prefixSid == null) {
            return;
        }
        for (BgpPrefixSidTlvs tlv : prefixSid.getBgpPrefixSidTlvs()) {
            this.reg.serializeBgpPrefixSidTlv(tlv.getBgpPrefixSidTlv(), byteAggregator);
        }
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPParsingException {
        BgpPrefixSidBuilder sid = new BgpPrefixSidBuilder();
        ArrayList<BgpPrefixSidTlvs> tlvList = new ArrayList<BgpPrefixSidTlvs>();
        while (buffer.isReadable()) {
            tlvList.add(new BgpPrefixSidTlvsBuilder().setBgpPrefixSidTlv(this.reg.parseBgpPrefixSidTlv((int)buffer.readUnsignedByte(), buffer)).build());
        }
        builder.setBgpPrefixSid(sid.setBgpPrefixSidTlvs(tlvList).build());
    }
}

