/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.ExtendedCommunities;

public final class ExtendedCommunitiesAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    public static final int TYPE = 16;
    private final ExtendedCommunityRegistry ecReg;

    public ExtendedCommunitiesAttributeParser(ExtendedCommunityRegistry ecReg) {
        this.ecReg = Objects.requireNonNull(ecReg);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        int readable = buffer.readableBytes();
        if (errorHandling != RevisedErrorHandling.NONE && readable == 0) {
            throw new BGPTreatAsWithdrawException(BGPError.ATTR_LENGTH_ERROR, "Empty Extended Community attribute", new Object[0]);
        }
        if (readable % 8 != 0) {
            throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "Extended Community attribute length must be a multiple of 8, have %s", new Object[]{readable});
        }
        ArrayList<ExtendedCommunities> set = new ArrayList<ExtendedCommunities>(readable / 8);
        while (buffer.isReadable()) {
            ExtendedCommunities exComm;
            try {
                exComm = this.ecReg.parseExtendedCommunity(buffer);
            }
            catch (BGPParsingException e) {
                throw errorHandling.reportError(BGPError.MALFORMED_ATTR_LIST, (Exception)((Object)e), "Failed to parse extended community", new Object[0]);
            }
            if (exComm == null) continue;
            set.add(exComm);
        }
        builder.setExtendedCommunities(set);
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        List communitiesList = pathAttributes.getExtendedCommunities();
        if (communitiesList == null || communitiesList.isEmpty()) {
            return;
        }
        ByteBuf extendedCommunitiesBuffer = Unpooled.buffer();
        for (ExtendedCommunities extendedCommunities : communitiesList) {
            this.ecReg.serializeExtendedCommunity(extendedCommunities, extendedCommunitiesBuffer);
        }
        if (extendedCommunitiesBuffer.readableBytes() > 0) {
            AttributeUtil.formatAttribute((int)192, (int)16, (ByteBuf)extendedCommunitiesBuffer, (ByteBuf)byteAggregator);
        }
    }
}

