/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractOpaqueExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.EncapsulationTunnelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.EncapsulationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.EncapsulationCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.encapsulation._case.EncapsulationExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.encapsulation._case.EncapsulationExtendedCommunityBuilder;

public class EncapsulationEC
extends AbstractOpaqueExtendedCommunity {
    @VisibleForTesting
    public static final int SUBTYPE = 12;
    private static final int RESERVED_SIZE = 4;
    private static final int CONTENT_SIZE = 6;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        Preconditions.checkArgument((buffer.readableBytes() == 6 ? 1 : 0) != 0, (Object)("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "."));
        buffer.skipBytes(4);
        EncapsulationExtendedCommunity encap = new EncapsulationExtendedCommunityBuilder().setTunnelType(EncapsulationTunnelType.forValue((int)buffer.readUnsignedShort())).build();
        return new EncapsulationCaseBuilder().setEncapsulationExtendedCommunity(encap).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf body) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof EncapsulationCase), (String)"The extended community %s is not EncapsulationCase type.", (Object)extendedCommunity);
        EncapsulationExtendedCommunity encap = ((EncapsulationCase)extendedCommunity).getEncapsulationExtendedCommunity();
        body.writeZero(4);
        body.writeShort(encap.getTunnelType().getIntValue());
    }

    public int getSubType() {
        return 12;
    }
}

