/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target.RouteTargetExtendedCommunityHandler;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractTwoOctetAsExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.RouteTargetExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.route.target.extended.community.grouping.RouteTargetExtendedCommunity;

public final class RouteTargetAsTwoOctetEcHandler
extends AbstractTwoOctetAsExtendedCommunity {
    private static final int SUBTYPE = 2;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        return new RouteTargetExtendedCommunityCaseBuilder().setRouteTargetExtendedCommunity(RouteTargetExtendedCommunityHandler.parse(buffer)).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof RouteTargetExtendedCommunityCase), (String)"The extended community %s is not RouteTargetExtendedCommunityCase type.", (Object)extendedCommunity);
        RouteTargetExtendedCommunity routeTarget = ((RouteTargetExtendedCommunityCase)extendedCommunity).getRouteTargetExtendedCommunity();
        RouteTargetExtendedCommunityHandler.serialize(routeTarget, byteAggregator);
    }

    public int getSubType() {
        return 2;
    }
}

