/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.route.target.ipv4.grouping.RouteTargetIpv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.route.target.ipv4.grouping.RouteTargetIpv4Builder;

public final class RouteTargetIpv4Handler {
    private RouteTargetIpv4Handler() {
        throw new UnsupportedOperationException();
    }

    public static void serialize(RouteTargetIpv4 routeTarget, ByteBuf byteAggregator) {
        ByteBufWriteUtil.writeIpv4Address((Ipv4Address)routeTarget.getGlobalAdministrator(), (ByteBuf)byteAggregator);
        ByteBufWriteUtil.writeUnsignedShort((Integer)routeTarget.getLocalAdministrator(), (ByteBuf)byteAggregator);
    }

    public static RouteTargetIpv4 parse(ByteBuf buffer) {
        return new RouteTargetIpv4Builder().setGlobalAdministrator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).setLocalAdministrator(Integer.valueOf(buffer.readUnsignedShort())).build();
    }
}

