/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.AddPathCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.AddPathCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamiliesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class AddPathCapabilityHandler
implements CapabilityParser,
CapabilitySerializer {
    public static final int CODE = 69;
    private static final int TRIPLET_BYTE_SIZE = 4;
    private final AddressFamilyRegistry afiReg;
    private final SubsequentAddressFamilyRegistry safiReg;

    public AddPathCapabilityHandler(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = Objects.requireNonNull(afiReg);
        this.safiReg = Objects.requireNonNull(safiReg);
    }

    public void serializeCapability(CParameters capability, ByteBuf byteAggregator) {
        CParameters1 aug = (CParameters1)capability.augmentation(CParameters1.class);
        if (aug == null) {
            return;
        }
        AddPathCapability addPathCap = aug.getAddPathCapability();
        if (addPathCap == null) {
            return;
        }
        List families = addPathCap.getAddressFamilies();
        if (families != null) {
            ByteBuf capBuffer = Unpooled.buffer((int)(families.size() * 4));
            for (AddressFamilies addressFamily : families) {
                Class afi = addressFamily.getAfi();
                Integer afival = this.afiReg.numberForClass(afi);
                Preconditions.checkArgument((afival != null ? 1 : 0) != 0, (Object)("Unhandled address family " + afi));
                Class safi = addressFamily.getSafi();
                Integer safival = this.safiReg.numberForClass(safi);
                Preconditions.checkArgument((safival != null ? 1 : 0) != 0, (Object)("Unhandled subsequent address family " + safi));
                SendReceive sendReceive = addressFamily.getSendReceive();
                Preconditions.checkArgument((sendReceive != null ? 1 : 0) != 0, (Object)"Unhandled Send/Receive value");
                capBuffer.writeShort(afival.intValue()).writeByte(safival.intValue()).writeByte(sendReceive.getIntValue());
            }
            CapabilityUtil.formatCapability((int)69, (ByteBuf)capBuffer, (ByteBuf)byteAggregator);
        }
    }

    public CParameters parseCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        ArrayList<AddressFamilies> families = new ArrayList<AddressFamilies>();
        while (buffer.isReadable()) {
            int afiVal = buffer.readUnsignedShort();
            Class afi = this.afiReg.classForFamily(afiVal);
            if (afi == null) {
                throw new BGPParsingException("Address Family Identifier: '" + afiVal + "' not supported.");
            }
            short safiVal = buffer.readUnsignedByte();
            Class safi = this.safiReg.classForFamily((int)safiVal);
            if (safi == null) {
                throw new BGPParsingException("Subsequent Address Family Identifier: '" + safiVal + "' not supported.");
            }
            SendReceive sendReceive = SendReceive.forValue((int)buffer.readUnsignedByte());
            if (sendReceive == null) continue;
            families.add(new AddressFamiliesBuilder().setAfi(afi).setSafi(safi).setSendReceive(sendReceive).build());
        }
        return new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setAddPathCapability(new AddPathCapabilityBuilder().setAddressFamilies(families).build()).build()).build();
    }
}

