/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GracefulCapabilityHandler
implements CapabilityParser,
CapabilitySerializer {
    public static final int CODE = 64;
    private static final Logger LOG = LoggerFactory.getLogger(GracefulCapabilityHandler.class);
    private static final int RESTART_FLAGS_SIZE = 4;
    private static final int RESTART_FLAG_STATE = 32768;
    private static final int TIMER_SIZE = 12;
    private static final int TIMER_TOPBITS_MASK = 15;
    private static final int HEADER_SIZE = 2;
    private static final int PER_AFI_SAFI_SIZE = 4;
    private static final short AFI_FLAG_FORWARDING_STATE = 128;
    private static final int MAX_RESTART_TIME = 4095;
    private final AddressFamilyRegistry afiReg;
    private final SubsequentAddressFamilyRegistry safiReg;

    public GracefulCapabilityHandler(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = Objects.requireNonNull(afiReg);
        this.safiReg = Objects.requireNonNull(safiReg);
    }

    private void serializeTables(List<Tables> tables, ByteBuf bytes) {
        if (tables == null) {
            return;
        }
        for (Tables t : tables) {
            Class afi = t.getAfi();
            Integer afival = this.afiReg.numberForClass(afi);
            Preconditions.checkArgument((afival != null ? 1 : 0) != 0, (Object)("Unhandled address family " + afi));
            bytes.writeShort(afival.intValue());
            Class safi = t.getSafi();
            Integer safival = this.safiReg.numberForClass(safi);
            Preconditions.checkArgument((safival != null ? 1 : 0) != 0, (Object)("Unhandled subsequent address family " + safi));
            bytes.writeByte(safival.intValue());
            if (t.getAfiFlags() != null && t.getAfiFlags().isForwardingState().booleanValue()) {
                bytes.writeByte(128);
                continue;
            }
            bytes.writeZero(1);
        }
    }

    private ByteBuf serializeCapability(GracefulRestartCapability grace) {
        List tables = grace.getTables();
        int tablesSize = tables != null ? tables.size() : 0;
        ByteBuf bytes = Unpooled.buffer((int)(2 + 4 * tablesSize));
        int timeval = 0;
        Integer time = grace.getRestartTime();
        if (time == null) {
            time = 0;
        }
        Preconditions.checkArgument((time >= 0 && time <= 4095 ? 1 : 0) != 0, (Object)("Restart time is " + time));
        timeval = time;
        GracefulRestartCapability.RestartFlags flags = grace.getRestartFlags();
        if (flags != null && flags.isRestartState().booleanValue()) {
            ByteBufWriteUtil.writeUnsignedShort((Integer)(0x8000 | timeval), (ByteBuf)bytes);
        } else {
            ByteBufWriteUtil.writeUnsignedShort((Integer)timeval, (ByteBuf)bytes);
        }
        this.serializeTables(tables, bytes);
        return bytes;
    }

    public void serializeCapability(CParameters capability, ByteBuf byteAggregator) {
        CParameters1 aug = (CParameters1)capability.augmentation(CParameters1.class);
        if (aug == null) {
            return;
        }
        GracefulRestartCapability grace = aug.getGracefulRestartCapability();
        if (grace != null) {
            ByteBuf bytes = this.serializeCapability(grace);
            CapabilityUtil.formatCapability((int)64, (ByteBuf)bytes, (ByteBuf)byteAggregator);
        }
    }

    public CParameters parseCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        GracefulRestartCapabilityBuilder cb = new GracefulRestartCapabilityBuilder();
        int flagBits = buffer.getByte(0) >> 4;
        cb.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf((flagBits & 8) != 0)));
        int timer = ((buffer.readUnsignedByte() & 0xF) << 8) + buffer.readUnsignedByte();
        cb.setRestartTime(Integer.valueOf(timer));
        ArrayList<Tables> tables = new ArrayList<Tables>();
        while (buffer.readableBytes() != 0) {
            short afiVal = buffer.readShort();
            Class afi = this.afiReg.classForFamily((int)afiVal);
            if (afi == null) {
                LOG.debug("Ignoring GR capability for unknown address family {}", (Object)afiVal);
                buffer.skipBytes(2);
                continue;
            }
            short safiVal = buffer.readUnsignedByte();
            Class safi = this.safiReg.classForFamily((int)safiVal);
            if (safi == null) {
                LOG.debug("Ignoring GR capability for unknown subsequent address family {}", (Object)safiVal);
                buffer.skipBytes(1);
                continue;
            }
            short flags = buffer.readUnsignedByte();
            tables.add(new TablesBuilder().setAfi(afi).setSafi(safi).setAfiFlags(new Tables.AfiFlags(Boolean.valueOf((flags & 0x80) != 0))).build());
        }
        cb.setTables(tables);
        return new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(cb.build()).build()).build();
    }
}

