/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.AigpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.aigp.AigpTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.aigp.AigpTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.AccumulatedIgpMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AigpAttributeParser
implements AttributeParser,
AttributeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AigpAttributeParser.class);
    private static final byte AIGP_TLV_TYPE = 1;
    private static final short AIGP_TLV_SIZE = 11;
    private static final int TLV_SIZE_IN_BYTES = 2;
    public static final int TYPE = 26;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, PeerSpecificParserConstraint constraint) {
        if (buffer.isReadable()) {
            builder.setAigp(new AigpBuilder().setAigpTlv(AigpAttributeParser.parseAigpTLV(buffer)).build());
        }
    }

    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        Aigp aigpAttribute = attribute.getAigp();
        if (aigpAttribute != null) {
            AttributeUtil.formatAttribute((int)128, (int)26, (ByteBuf)AigpAttributeParser.serializeAigpTLV(aigpAttribute), (ByteBuf)byteAggregator);
        }
    }

    private static AigpTlv parseAigpTLV(ByteBuf buffer) {
        byte tlvType = buffer.readByte();
        buffer.skipBytes(2);
        if (tlvType != 1) {
            LOG.warn("AIGP attribute contains unknown TLV type {}.", (Object)tlvType);
            return null;
        }
        return new AigpTlvBuilder().setMetric(new AccumulatedIgpMetric(BigInteger.valueOf(buffer.readLong()))).build();
    }

    private static ByteBuf serializeAigpTLV(Aigp aigp) {
        AigpTlv tlv = aigp.getAigpTlv();
        if (tlv == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.buffer((int)11).writeByte(1).writeShort(11).writeLong(tlv.getMetric().getValue().longValue());
    }
}

