/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AsPathSegmentParser;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.as.path.SegmentsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsPathAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    public static final int TYPE = 2;
    private final ReferenceCache refCache;
    private static final Logger LOG = LoggerFactory.getLogger(AsPathAttributeParser.class);
    private static final AsPath EMPTY = new AsPathBuilder().setSegments(Collections.emptyList()).build();

    public AsPathAttributeParser(ReferenceCache refCache) {
        this.refCache = Objects.requireNonNull(refCache);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        builder.setAsPath(AsPathAttributeParser.parseAsPath(this.refCache, buffer, errorHandling));
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        AsPath asPath = pathAttributes.getAsPath();
        if (asPath == null) {
            return;
        }
        ByteBuf segmentsBuffer = Unpooled.buffer();
        if (asPath.getSegments() != null) {
            for (Segments segments : asPath.getSegments()) {
                if (segments.getAsSequence() != null) {
                    AsPathSegmentParser.serializeAsList(segments.getAsSequence(), AsPathSegmentParser.SegmentType.AS_SEQUENCE, segmentsBuffer);
                    continue;
                }
                if (segments.getAsSet() != null) {
                    AsPathSegmentParser.serializeAsList(segments.getAsSet(), AsPathSegmentParser.SegmentType.AS_SET, segmentsBuffer);
                    continue;
                }
                LOG.warn("Segment doesn't have AsSequence nor AsSet list.");
            }
        }
        AttributeUtil.formatAttribute((int)64, (int)2, (ByteBuf)segmentsBuffer, (ByteBuf)byteAggregator);
    }

    private static AsPath parseAsPath(ReferenceCache refCache, ByteBuf buffer, RevisedErrorHandling errorHandling) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        if (!buffer.isReadable()) {
            return EMPTY;
        }
        ArrayList<Segments> ases = new ArrayList<Segments>();
        boolean isSequence = false;
        int readable = buffer.readableBytes();
        while (readable != 0) {
            if (readable < 2) {
                throw errorHandling.reportError(BGPError.AS_PATH_MALFORMED, "Insufficient AS PATH segment header length %s", new Object[]{readable});
            }
            short type = buffer.readUnsignedByte();
            AsPathSegmentParser.SegmentType segmentType = AsPathSegmentParser.parseType(type);
            if (segmentType == null) {
                throw errorHandling.reportError(BGPError.AS_PATH_MALFORMED, "Unknown AS PATH segment type %s", new Object[]{(int)type});
            }
            short count = buffer.readUnsignedByte();
            if (count == 0 && errorHandling != RevisedErrorHandling.NONE) {
                throw new BGPTreatAsWithdrawException(BGPError.AS_PATH_MALFORMED, "Empty AS_PATH segment", new Object[0]);
            }
            int segmentLength = count * 4;
            if (segmentLength > (readable -= 2)) {
                throw errorHandling.reportError(BGPError.AS_PATH_MALFORMED, "Calculated segment length %s would overflow available buffer %s", new Object[]{segmentLength, readable});
            }
            ImmutableList<AsNumber> asList = AsPathSegmentParser.parseAsSegment(refCache, count, buffer.readSlice(segmentLength));
            if (segmentType == AsPathSegmentParser.SegmentType.AS_SEQUENCE) {
                ases.add(new SegmentsBuilder().setAsSequence(asList).build());
                isSequence = true;
            } else {
                ases.add(new SegmentsBuilder().setAsSet(asList).build());
            }
            readable = buffer.readableBytes();
        }
        if (!isSequence) {
            throw errorHandling.reportError(BGPError.AS_PATH_MALFORMED, "AS_SEQUENCE must be present in AS_PATH attribute.", new Object[0]);
        }
        return new AsPathBuilder().setSegments((List)ImmutableList.copyOf(ases)).build();
    }
}

