/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.ReachAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.Attributes1Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public final class MPReachAttributeParser
extends ReachAttributeParser {
    public static final int TYPE = 14;
    private final NlriRegistry reg;

    public MPReachAttributeParser(NlriRegistry reg) {
        this.reg = Objects.requireNonNull(reg);
    }

    @Override
    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        try {
            builder.addAugmentation(Attributes1.class, (Augmentation)new Attributes1Builder().setMpReachNlri(this.reg.parseMpReach(buffer, constraint)).build());
        }
        catch (BGPParsingException e) {
            throw new BGPDocumentedException("Could not parse MP_REACH_NLRI", BGPError.OPT_ATTR_ERROR, (Exception)((Object)e));
        }
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        Attributes1 pathAttributes1 = (Attributes1)pathAttributes.augmentation(Attributes1.class);
        if (pathAttributes1 != null) {
            ByteBuf reachBuffer = Unpooled.buffer();
            this.reg.serializeMpReach(pathAttributes1.getMpReachNlri(), reachBuffer);
            for (NlriSerializer nlriSerializer : this.reg.getSerializers()) {
                nlriSerializer.serializeAttribute(pathAttributes, reachBuffer);
            }
            AttributeUtil.formatAttribute((int)128, (int)14, (ByteBuf)reachBuffer, (ByteBuf)byteAggregator);
        }
    }
}

