/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.UnrecognizedAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnrecognizedAttributesSerializer
implements AttributeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(UnrecognizedAttributesSerializer.class);

    public void serializeAttribute(Attributes attributes, ByteBuf byteAggregator) {
        List unrecognizedAttrs = attributes.getUnrecognizedAttributes();
        if (unrecognizedAttrs == null) {
            return;
        }
        for (UnrecognizedAttributes unrecognizedAttr : unrecognizedAttrs) {
            LOG.trace("Serializing unrecognized attribute of type {}", (Object)unrecognizedAttr.getType());
            int flags = 128;
            if (unrecognizedAttr.isPartial().booleanValue()) {
                flags |= 0x20;
            }
            if (unrecognizedAttr.isTransitive().booleanValue()) {
                flags |= 0x40;
            }
            AttributeUtil.formatAttribute((int)flags, (int)unrecognizedAttr.getType().shortValue(), (ByteBuf)Unpooled.wrappedBuffer((byte[])unrecognizedAttr.getValue()), (ByteBuf)byteAggregator);
        }
    }
}

