/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractTwoOctetAsExtendedCommunity;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.AsSpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.AsSpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.as.specific.extended.community._case.AsSpecificExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.as.specific.extended.community._case.AsSpecificExtendedCommunityBuilder;

public class AsTwoOctetSpecificEcHandler
extends AbstractTwoOctetAsExtendedCommunity {
    private static final int SUBTYPE = 0;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        AsSpecificExtendedCommunity asSpecific = new AsSpecificExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Long.valueOf(buffer.readUnsignedShort()))).setLocalAdministrator(ByteArray.readBytes((ByteBuf)buffer, (int)4)).build();
        return new AsSpecificExtendedCommunityCaseBuilder().setAsSpecificExtendedCommunity(asSpecific).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof AsSpecificExtendedCommunityCase), (String)"The extended community %s is not AsSpecificExtendedCommunity type.", (Object)extendedCommunity);
        AsSpecificExtendedCommunity asSpecific = ((AsSpecificExtendedCommunityCase)extendedCommunity).getAsSpecificExtendedCommunity();
        ByteBufWriteUtil.writeUnsignedShort((Integer)Ints.checkedCast((long)asSpecific.getGlobalAdministrator().getValue()), (ByteBuf)byteAggregator);
        byteAggregator.writeBytes(asSpecific.getLocalAdministrator());
    }

    public int getSubType() {
        return 0;
    }
}

