/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.route.target.extended.community.grouping.RouteTargetExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.route.target.extended.community.grouping.RouteTargetExtendedCommunityBuilder;

public final class RouteTargetExtendedCommunityHandler {
    private RouteTargetExtendedCommunityHandler() {
        throw new UnsupportedOperationException();
    }

    public static RouteTargetExtendedCommunity parse(ByteBuf buffer) {
        return new RouteTargetExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Long.valueOf(buffer.readUnsignedShort()))).setLocalAdministrator(ByteArray.readBytes((ByteBuf)buffer, (int)4)).build();
    }

    public static void serialize(RouteTargetExtendedCommunity routeTarget, ByteBuf byteAggregator) {
        ByteBufWriteUtil.writeUnsignedShort((Integer)Ints.checkedCast((long)routeTarget.getGlobalAdministrator().getValue()), (ByteBuf)byteAggregator);
        byteAggregator.writeBytes(routeTarget.getLocalAdministrator());
    }
}

