/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHopBuilder;

public class IPv6NextHopTest {
    private Ipv6NextHop nextHopA;
    private Ipv6NextHop nextHopB;

    @Before
    public void init() {
        this.nextHopA = new Ipv6NextHopBuilder().setGlobal(new Ipv6AddressNoZone("2001:db8:85a3:0:0:8a2e:370:7331")).build();
        this.nextHopB = new Ipv6NextHopBuilder().setGlobal(new Ipv6AddressNoZone("2001:db8:85a3:0:0:8a2e:370:7331")).setLinkLocal(new Ipv6AddressNoZone("2001:db8:85a3:0:0:8a2e:370:0000")).build();
    }

    @Test
    public void testGetGlobal() {
        Ipv6Address globalTestAddress = new Ipv6Address("2001:db8:85a3:0:0:8a2e:370:7331");
        Assert.assertEquals((Object)this.nextHopA.getGlobal(), (Object)globalTestAddress);
        Assert.assertEquals((Object)this.nextHopB.getGlobal(), (Object)globalTestAddress);
    }

    @Test
    public void testGetLinkLocal() {
        Ipv6Address localTestAddress = new Ipv6Address("2001:db8:85a3:0:0:8a2e:370:0000");
        Assert.assertNull((Object)this.nextHopA.getLinkLocal());
        Assert.assertEquals((Object)this.nextHopB.getLinkLocal(), (Object)localTestAddress);
    }
}

