/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AigpAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.pojo.DefaultBGPExtensionConsumerContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.aigp.AigpTlv;

public class PathAttributeParserTest {
    private final DefaultBGPExtensionConsumerContext ctx = new DefaultBGPExtensionConsumerContext();

    @Test
    public void testOriginParser() {
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> this.ctx.getAttributeRegistry().parseAttributes(Unpooled.copiedBuffer((byte[])new byte[]{64, 1, 1, 4}), null));
        Assert.assertEquals((Object)"Unknown ORIGIN type 4", (Object)ex.getMessage());
    }

    @Test
    public void testParsingAigpAttributeWithCorrectTLV() throws BGPDocumentedException, BGPParsingException {
        byte[] value = new byte[]{1, 0, 11, 0, 0, 0, 0, 0, 0, 0, 8};
        ByteBuf buffer = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)128, (int)26, (ByteBuf)Unpooled.copiedBuffer((byte[])value), (ByteBuf)buffer);
        Attributes pathAttributes = this.ctx.getAttributeRegistry().parseAttributes(buffer, null).getAttributes();
        Aigp aigp = pathAttributes.getAigp();
        AigpTlv tlv = aigp.getAigpTlv();
        Assert.assertNotNull((String)"Tlv should not be null.", (Object)tlv);
        Assert.assertEquals((String)"Aigp tlv should have metric with value 8.", (long)8L, (long)tlv.getMetric().getValue().intValue());
    }

    @Test
    public void testSerializingAigpAttribute() throws BGPDocumentedException, BGPParsingException {
        byte[] value = new byte[]{1, 0, 11, 0, 0, 0, 0, 0, 0, 0, 8};
        ByteBuf inputData = Unpooled.buffer();
        ByteBuf testBuffer = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)128, (int)26, (ByteBuf)Unpooled.copiedBuffer((byte[])value), (ByteBuf)inputData);
        Attributes pathAttributes = this.ctx.getAttributeRegistry().parseAttributes(inputData, null).getAttributes();
        Aigp aigp = pathAttributes.getAigp();
        AttributesBuilder pathAttributesBuilder = new AttributesBuilder();
        pathAttributesBuilder.setAigp(aigp);
        AigpAttributeParser parser = new AigpAttributeParser();
        parser.serializeAttribute(pathAttributesBuilder.build(), testBuffer);
        byte[] unparserData = inputData.copy(0, inputData.writerIndex()).array();
        byte[] serializedData = testBuffer.copy(0, inputData.writerIndex()).array();
        Assert.assertArrayEquals((byte[])unparserData, (byte[])serializedData);
    }
}

