/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.open.RouteRefreshCapabilityHandler;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.RouteRefreshCapabilityBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class RouteRefreshCapabilityHandlerTest {
    private static final RouteRefreshCapabilityHandler HANDLER = new RouteRefreshCapabilityHandler();
    private static final byte[] WRONG_BYTES = new byte[]{1, 2};
    private static final byte[] OK_BYTES = new byte[]{0};
    private static final byte[] CAP_BYTES = new byte[]{2, 0};

    @Test
    public void testRRCapHandler() throws BGPDocumentedException, BGPParsingException {
        CParameters expectedParams = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setRouteRefreshCapability(new RouteRefreshCapabilityBuilder().build()).build()).build();
        Assert.assertEquals((Object)expectedParams, (Object)HANDLER.parseCapability(Unpooled.copiedBuffer((byte[])OK_BYTES)));
        Assert.assertEquals((Object)expectedParams, (Object)HANDLER.parseCapability(Unpooled.copiedBuffer((byte[])WRONG_BYTES)));
        ByteBuf byteAggregator = Unpooled.buffer((int)2);
        HANDLER.serializeCapability(expectedParams, byteAggregator);
        Assert.assertEquals((Object)Unpooled.copiedBuffer((byte[])CAP_BYTES), (Object)byteAggregator);
        CParameters missingCap = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setRouteRefreshCapability(null).build()).build();
        ByteBuf byteAggregator2 = Unpooled.buffer((int)0);
        HANDLER.serializeCapability(missingCap, byteAggregator2);
        Assert.assertEquals((Object)Unpooled.copiedBuffer((byte[])new byte[0]), (Object)byteAggregator2);
    }
}

