/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public class AsPathAttributeParserTest {
    private static final byte[] ATTRIBUTE_BYTES = new byte[]{64, 2, 20, 1, 2, 0, 0, 0, 1, 0, 0, 0, 2, 2, 2, 0, 0, 0, 3, 0, 0, 0, 4};
    private static final byte[] EMPTY_ATTRIBUTE_BYTES = new byte[]{64, 2, 0};
    private final AttributeRegistry registry = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry();

    @Test
    public void testAttributeParser() throws BGPParsingException, BGPDocumentedException {
        Attributes attr = new AttributesBuilder().setAsPath(new AsPathBuilder().setSegments(List.of(new SegmentsBuilder().setAsSet(List.of(new AsNumber(Uint32.ONE), new AsNumber(Uint32.TWO))).build(), new SegmentsBuilder().setAsSequence(List.of(new AsNumber(Uint32.valueOf((int)3)), new AsNumber(Uint32.valueOf((int)4)))).build())).build()).build();
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(attr, actual);
        Assert.assertArrayEquals((byte[])ATTRIBUTE_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.registry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)attr.getAsPath(), (Object)attributeOut.getAsPath());
    }

    @Test
    public void testParseEmptyAttribute() {
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(new AttributesBuilder().setAsPath(new AsPathBuilder().build()).build(), actual);
        Assert.assertEquals((Object)Unpooled.buffer().writeBytes(EMPTY_ATTRIBUTE_BYTES), (Object)actual);
    }
}

