/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public class MultiExitDiscriminatorAttributeParserTest {
    private static final byte[] ATTRIBUTE_BYTES = new byte[]{-128, 4, 4, 0, 0, 0, 1};
    private static final Attributes RESULT = new AttributesBuilder().setMultiExitDisc(new MultiExitDiscBuilder().setMed(Uint32.ONE).build()).build();
    private final AttributeRegistry registry = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry();

    @Test
    public void testAttributeParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(RESULT, actual);
        Assert.assertArrayEquals((byte[])ATTRIBUTE_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.registry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)RESULT.getMultiExitDisc(), (Object)attributeOut.getMultiExitDisc());
    }

    @Test
    public void testParseEmptyAttribute() {
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(new AttributesBuilder().setMultiExitDisc(new MultiExitDiscBuilder().build()).build(), actual);
        Assert.assertEquals((Object)Unpooled.buffer(), (Object)actual);
    }
}

