/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.open.LlGracefulCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.routing.types.rev171204.Uint24;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Uint32;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class LlGracefulCapabilityHandlerTest {
    private static final Uint24 TEN = new Uint24(Uint32.TEN);
    private LlGracefulCapabilityHandler handler;
    @Mock
    private AddressFamilyRegistry afir;
    @Mock
    private SubsequentAddressFamilyRegistry safir;

    @Before
    public void setUp() {
        ((AddressFamilyRegistry)Mockito.doReturn(Ipv4AddressFamily.class).when((Object)this.afir)).classForFamily(1);
        ((AddressFamilyRegistry)Mockito.doReturn(Ipv6AddressFamily.class).when((Object)this.afir)).classForFamily(2);
        ((AddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.afir)).classForFamily(256);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(UnicastSubsequentAddressFamily.class).when((Object)this.safir)).classForFamily(1);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.safir)).classForFamily(-123);
        BGPExtensionConsumerContext ctx = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow();
        this.handler = new LlGracefulCapabilityHandler(ctx.getAddressFamilyRegistry(), ctx.getSubsequentAddressFamilyRegistry());
    }

    @Test
    public void testLongLivedGracefulCapabilityHandler() throws BGPParsingException, BGPDocumentedException {
        byte[] capaBytes = new byte[]{71, 14, 0, 1, 1, 0, 0, 0, 10, 0, 2, 1, -128, 0, 0, -96};
        LlGracefulRestartCapability capability = new LlGracefulRestartCapabilityBuilder().setTables(BindingMap.ordered((Identifiable)new TablesBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.FALSE)).setLongLivedStaleTime(TEN).build(), (Identifiable)new TablesBuilder().setAfi(Ipv6AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.TRUE)).setLongLivedStaleTime(new Uint24(Uint32.valueOf((int)160))).build())).build();
        CParameters cParameters = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setLlGracefulRestartCapability(capability).build()).build();
        ByteBuf buffer = Unpooled.buffer((int)capaBytes.length);
        this.handler.serializeCapability(cParameters, buffer);
        Assert.assertArrayEquals((byte[])capaBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)cParameters, (Object)this.handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes).slice(2, capaBytes.length - 2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedAfi() {
        LlGracefulRestartCapability capability = new LlGracefulRestartCapabilityBuilder().setTables(BindingMap.of((Identifiable)new TablesBuilder().setAfi(AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.FALSE)).setLongLivedStaleTime(TEN).build())).build();
        CParameters cParameters = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setLlGracefulRestartCapability(capability).build()).build();
        ByteBuf buffer = Unpooled.buffer();
        this.handler.serializeCapability(cParameters, buffer);
    }

    @Test
    public void testRecvdUnsupportedAfi() {
        byte[] capaBytes = new byte[]{71, 21, 0, 1, 1, 0, 0, 0, 10, 1, 0, 1, -128, 0, 0, -96, 0, 2, 1, 0, 0, 0, -96};
        LlGracefulRestartCapability capability = new LlGracefulRestartCapabilityBuilder().setTables(BindingMap.ordered((Identifiable)new TablesBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.FALSE)).setLongLivedStaleTime(TEN).build(), (Identifiable)new TablesBuilder().setAfi(Ipv6AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.FALSE)).setLongLivedStaleTime(new Uint24(Uint32.valueOf((int)160))).build())).build();
        CParameters cParameters = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setLlGracefulRestartCapability(capability).build()).build();
        LlGracefulCapabilityHandler handler1 = new LlGracefulCapabilityHandler(this.afir, this.safir);
        Assert.assertEquals((Object)cParameters, (Object)handler1.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes).slice(2, capaBytes.length - 2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedSafi() {
        LlGracefulRestartCapability capability = new LlGracefulRestartCapabilityBuilder().setTables(BindingMap.of((Identifiable)new TablesBuilder().setAfi(Ipv4AddressFamily.class).setSafi(SubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.FALSE)).setLongLivedStaleTime(TEN).build())).build();
        CParameters cParameters = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setLlGracefulRestartCapability(capability).build()).build();
        ByteBuf buffer = Unpooled.buffer();
        this.handler.serializeCapability(cParameters, buffer);
    }

    @Test
    public void testRecvdUnsupportedSafi() {
        byte[] capaBytes = new byte[]{71, 21, 0, 1, 1, 0, 0, 0, 10, 0, 1, -123, -128, 0, 0, -96, 0, 2, 1, -128, 0, 0, -96};
        LlGracefulRestartCapability capability = new LlGracefulRestartCapabilityBuilder().setTables(BindingMap.ordered((Identifiable)new TablesBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.FALSE)).setLongLivedStaleTime(TEN).build(), (Identifiable)new TablesBuilder().setAfi(Ipv6AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setAfiFlags(new Tables.AfiFlags(Boolean.TRUE)).setLongLivedStaleTime(new Uint24(Uint32.valueOf((int)160))).build())).build();
        CParameters cParameters = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setLlGracefulRestartCapability(capability).build()).build();
        LlGracefulCapabilityHandler handler1 = new LlGracefulCapabilityHandler(this.afir, this.safir);
        Assert.assertEquals((Object)cParameters, (Object)handler1.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes).slice(2, capaBytes.length - 2)));
    }
}

